/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.remoting;

import flex.messaging.Destination;
import flex.messaging.FactoryInstance;
import flex.messaging.FlexFactory;
import flex.messaging.MessageBroker;
import flex.messaging.config.ConfigMap;
import flex.messaging.services.RemotingService;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import flex.messaging.services.remoting.RemotingDestination;
import flex.messaging.services.remoting.adapters.JavaAdapter;
import flex.messaging.services.remoting.adapters.RemotingMethod;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.flex.core.AbstractDestinationFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotingDestinationExporter
extends AbstractDestinationFactory
implements FlexFactory {
    private static final Log log = LogFactory.getLog(RemotingDestinationExporter.class);
    private Object service;
    private String[] includeMethods;
    private String[] excludeMethods;
    private Class<?> sourceClass = null;

    public FactoryInstance createFactoryInstance(String id, ConfigMap properties) {
        return new ServiceFactoryInstance(this, id, properties);
    }

    public void initialize(String id, ConfigMap configMap) {
    }

    public Object lookup(FactoryInstance instanceInfo) {
        throw new UnsupportedOperationException("FlexFactory.lookup");
    }

    public void setExcludeMethods(String[] excludeMethods) {
        this.excludeMethods = StringUtils.trimArrayElements((String[])excludeMethods);
    }

    public void setIncludeMethods(String[] includeMethods) {
        this.includeMethods = StringUtils.trimArrayElements((String[])includeMethods);
    }

    public void setService(Object service) {
        this.service = service;
    }

    @Override
    protected Destination createDestination(String destinationId, MessageBroker broker) {
        Assert.notNull((Object)this.service, (String)"The 'service' property is required.");
        String source = null;
        if (this.service instanceof String) {
            String beanId = (String)this.service;
            this.service = this.getBeanFactory().getBean(beanId);
            this.sourceClass = AopUtils.getTargetClass((Object)this.service);
            if (this.sourceClass == null) {
                this.sourceClass = this.getBeanFactory().getType(beanId);
            }
        } else {
            this.sourceClass = AopUtils.getTargetClass((Object)this.service);
        }
        if (this.sourceClass != null) {
            source = this.sourceClass.getName();
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("The source class being exported as RemotingDestination with id '" + destinationId + "' cannot be calculated."));
        }
        RemotingService remotingService = (RemotingService)broker.getServiceByType(RemotingService.class.getName());
        Assert.notNull((Object)remotingService, (String)"Could not find a proper RemotingService in the Flex MessageBroker.");
        RemotingDestination destination = (RemotingDestination)remotingService.createDestination(destinationId);
        destination.setFactory((FlexFactory)this);
        destination.setSource(source);
        if (log.isInfoEnabled()) {
            log.info((Object)("Created remoting destination with id '" + destinationId + "'"));
        }
        return destination;
    }

    @Override
    protected void destroyDestination(String destinationId, MessageBroker broker) {
        RemotingService remotingService = (RemotingService)broker.getServiceByType(RemotingService.class.getName());
        if (remotingService == null) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Removing remoting destination '" + destinationId + "'"));
        }
        remotingService.removeDestination(destinationId);
    }

    @Override
    protected Service getTargetService(MessageBroker broker) {
        return broker.getServiceByType(RemotingService.class.getName());
    }

    @Override
    protected void initializeDestination(Destination destination) {
        destination.start();
        Assert.isInstanceOf(ServiceAdapter.class, (Object)destination.getAdapter(), (String)"Spring beans exported as a RemotingDestination require a ServiceAdapter.");
        this.configureIncludes(destination);
        this.configureExcludes(destination);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remoting destination '" + destination.getId() + "' has been started started successfully."));
        }
    }

    private void configureExcludes(Destination destination) {
        if (this.excludeMethods == null) {
            return;
        }
        JavaAdapter adapter = (JavaAdapter)destination.getAdapter();
        for (RemotingMethod method : this.getRemotingMethods(this.excludeMethods)) {
            adapter.addExcludeMethod(method);
        }
    }

    private void configureIncludes(Destination destination) {
        if (this.includeMethods == null) {
            return;
        }
        JavaAdapter adapter = (JavaAdapter)destination.getAdapter();
        for (RemotingMethod method : this.getRemotingMethods(this.includeMethods)) {
            adapter.addIncludeMethod(method);
        }
    }

    private List<RemotingMethod> getRemotingMethods(String[] methodNames) {
        ArrayList<RemotingMethod> remotingMethods = new ArrayList<RemotingMethod>();
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Class<?> classToCheck = this.sourceClass != null ? this.sourceClass : this.service.getClass();
            Assert.isTrue((boolean)ClassUtils.hasAtLeastOneMethodWithName(classToCheck, (String)name), (String)("Could not find method with name '" + name + "' on the exported service of type " + classToCheck));
            RemotingMethod method = new RemotingMethod();
            method.setName(name);
            remotingMethods.add(method);
            ++n2;
        }
        return remotingMethods;
    }

    private final class ServiceFactoryInstance
    extends FactoryInstance {
        public ServiceFactoryInstance(FlexFactory factory, String id, ConfigMap properties) {
            super(factory, id, properties);
        }

        public Object lookup() {
            return RemotingDestinationExporter.this.service;
        }
    }
}

