/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.FlexContext;
import flex.messaging.messages.Message;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class PerClientAuthenticationInterceptor
implements MessageInterceptor {
    public Message postProcess(MessageProcessingContext context, Message inputMessage, Message outputMessage) {
        SecurityContextHolder.clearContext();
        return outputMessage;
    }

    public Message preProcess(MessageProcessingContext context, Message inputMessage) {
        if (FlexContext.getUserPrincipal() != null) {
            Assert.isInstanceOf(Authentication.class, (Object)FlexContext.getUserPrincipal(), (String)("FlexContext.getUserPrincipal returned an unexpected type.  Expected instance of " + Authentication.class.getName() + "but was " + FlexContext.getUserPrincipal().getName()));
            SecurityContextHolder.getContext().setAuthentication((Authentication)FlexContext.getUserPrincipal());
        }
        return inputMessage;
    }
}

