/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.spi.mapper.MappingProvider;
import io.rsocket.transport.ClientTransport;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.graphql.client.RSocketGraphQlClient;
import org.springframework.graphql.test.tester.AbstractDelegatingGraphQlTester;
import org.springframework.graphql.test.tester.AbstractGraphQlTesterBuilder;
import org.springframework.graphql.test.tester.EncoderDecoderMappingProvider;
import org.springframework.graphql.test.tester.GraphQlTester;
import org.springframework.graphql.test.tester.RSocketGraphQlTester;
import org.springframework.messaging.rsocket.RSocketRequester;
import org.springframework.messaging.rsocket.RSocketStrategies;
import org.springframework.util.MimeType;
import reactor.core.publisher.Mono;

public class DefaultRSocketGraphQlTesterBuilder
extends AbstractGraphQlTesterBuilder<DefaultRSocketGraphQlTesterBuilder>
implements RSocketGraphQlTester.Builder<DefaultRSocketGraphQlTesterBuilder> {
    private final RSocketGraphQlClient.Builder<?> rsocketGraphQlClientBuilder;

    DefaultRSocketGraphQlTesterBuilder() {
        this.rsocketGraphQlClientBuilder = RSocketGraphQlClient.builder();
    }

    DefaultRSocketGraphQlTesterBuilder(RSocketRequester.Builder requesterBuilder) {
        this.rsocketGraphQlClientBuilder = RSocketGraphQlClient.builder((RSocketRequester.Builder)requesterBuilder);
    }

    public DefaultRSocketGraphQlTesterBuilder(RSocketGraphQlClient rsocketGraphQlClient) {
        this.rsocketGraphQlClientBuilder = rsocketGraphQlClient.mutate();
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder tcp(String host, int port) {
        this.rsocketGraphQlClientBuilder.tcp(host, port);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder webSocket(URI uri) {
        this.rsocketGraphQlClientBuilder.webSocket(uri);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder clientTransport(ClientTransport clientTransport) {
        this.rsocketGraphQlClientBuilder.clientTransport(clientTransport);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder dataMimeType(MimeType dataMimeType) {
        this.rsocketGraphQlClientBuilder.dataMimeType(dataMimeType);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder route(String route) {
        this.rsocketGraphQlClientBuilder.route(route);
        return this;
    }

    @Override
    public DefaultRSocketGraphQlTesterBuilder rsocketRequester(Consumer<RSocketRequester.Builder> requesterConsumer) {
        this.rsocketGraphQlClientBuilder.rsocketRequester(requesterConsumer);
        return this;
    }

    @Override
    public RSocketGraphQlTester build() {
        this.registerJsonPathMappingProvider();
        RSocketGraphQlClient rsocketGraphQlClient = this.rsocketGraphQlClientBuilder.build();
        GraphQlTester graphQlTester = super.buildGraphQlTester(DefaultRSocketGraphQlTesterBuilder.asTransport((GraphQlClient)rsocketGraphQlClient));
        return new DefaultRSocketGraphQlTester(graphQlTester, rsocketGraphQlClient, this.getBuilderInitializer());
    }

    private void registerJsonPathMappingProvider() {
        this.rsocketGraphQlClientBuilder.rsocketRequester(builder -> builder.rsocketStrategies(strategiesBuilder -> this.configureJsonPathConfig(config -> {
            RSocketStrategies strategies = strategiesBuilder.build();
            List encoders = strategies.encoders();
            List decoders = strategies.decoders();
            return config.mappingProvider((MappingProvider)new EncoderDecoderMappingProvider(encoders, decoders));
        })));
    }

    private static class DefaultRSocketGraphQlTester
    extends AbstractDelegatingGraphQlTester
    implements RSocketGraphQlTester {
        private final RSocketGraphQlClient rsocketGraphQlClient;
        private final Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer;

        DefaultRSocketGraphQlTester(GraphQlTester delegate, RSocketGraphQlClient rsocketGraphQlClient, Consumer<AbstractGraphQlTesterBuilder<?>> builderInitializer) {
            super(delegate);
            this.rsocketGraphQlClient = rsocketGraphQlClient;
            this.builderInitializer = builderInitializer;
        }

        @Override
        public Mono<Void> start() {
            return this.rsocketGraphQlClient.start();
        }

        @Override
        public Mono<Void> stop() {
            return this.rsocketGraphQlClient.stop();
        }

        @Override
        public RSocketGraphQlTester.Builder<?> mutate() {
            DefaultRSocketGraphQlTesterBuilder builder = new DefaultRSocketGraphQlTesterBuilder(this.rsocketGraphQlClient);
            this.builderInitializer.accept(builder);
            return builder;
        }
    }
}

