/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionId;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.graphql.execution.DataFetcherExceptionResolver;
import org.springframework.graphql.execution.ErrorType;
import org.springframework.graphql.execution.ReactorContextManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

class ExceptionResolversExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Log logger = LogFactory.getLog(ExceptionResolversExceptionHandler.class);
    private final List<DataFetcherExceptionResolver> resolvers;

    ExceptionResolversExceptionHandler(List<DataFetcherExceptionResolver> resolvers) {
        Assert.notNull(resolvers, (String)"'resolvers' is required");
        this.resolvers = new ArrayList<DataFetcherExceptionResolver>(resolvers);
    }

    @Deprecated
    public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters handlerParameters) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<DataFetcherExceptionHandlerResult> handleException(DataFetcherExceptionHandlerParameters params) {
        Throwable exception = this.unwrapException(params);
        DataFetchingEnvironment env = params.getDataFetchingEnvironment();
        try {
            return Flux.fromIterable(this.resolvers).flatMap(resolver -> resolver.resolveException(exception, env)).map(errors -> DataFetcherExceptionHandlerResult.newResult().errors(errors).build()).next().doOnNext(result -> this.logResolvedException(exception, (DataFetcherExceptionHandlerResult)result)).onErrorResume(resolverEx -> Mono.just((Object)this.handleResolverError((Throwable)resolverEx, exception, env))).switchIfEmpty(Mono.fromCallable(() -> this.createInternalError(exception, env))).contextWrite(context -> {
                ContextView contextView = ReactorContextManager.getReactorContext(env.getGraphQlContext());
                return contextView.isEmpty() ? context : context.putAll(contextView);
            }).toFuture();
        }
        catch (Exception resolverEx2) {
            return CompletableFuture.completedFuture(this.handleResolverError(resolverEx2, exception, env));
        }
    }

    private DataFetcherExceptionHandlerResult handleResolverError(Throwable resolverException, Throwable originalException, DataFetchingEnvironment environment) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Failure while resolving " + originalException.getMessage()), resolverException);
        }
        return this.createInternalError(originalException, environment);
    }

    private Throwable unwrapException(DataFetcherExceptionHandlerParameters params) {
        Throwable ex = params.getException();
        return ex instanceof CompletionException ? ex.getCause() : ex;
    }

    private void logResolvedException(Throwable ex, DataFetcherExceptionHandlerResult result) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolved " + ex.getClass().getSimpleName() + " to GraphQL error(s): " + result.getErrors()), ex);
        }
    }

    private DataFetcherExceptionHandlerResult createInternalError(Throwable ex, DataFetchingEnvironment environment) {
        ExecutionId executionId = environment.getExecutionId();
        if (logger.isErrorEnabled()) {
            logger.error((Object)("Unresolved " + ex.getClass().getSimpleName() + " for executionId " + executionId), ex);
        }
        return DataFetcherExceptionHandlerResult.newResult((GraphQLError)GraphqlErrorBuilder.newError((DataFetchingEnvironment)environment).errorType((ErrorClassification)ErrorType.INTERNAL_ERROR).message((Object)((Object)ErrorType.INTERNAL_ERROR) + " for " + executionId, new Object[0]).build()).build();
    }
}

