/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import java.net.URI;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.springframework.graphql.ExecutionGraphQlRequest;
import org.springframework.graphql.support.DefaultExecutionGraphQlRequest;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebInputException;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class WebGraphQlRequest
extends DefaultExecutionGraphQlRequest
implements ExecutionGraphQlRequest {
    private static final MultiValueMap<String, HttpCookie> EMPTY_COOKIES = CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap());
    private final UriComponents uri;
    private final HttpHeaders headers;
    private final MultiValueMap<String, HttpCookie> cookies;
    private final Map<String, Object> attributes;

    @Deprecated
    public WebGraphQlRequest(URI uri, HttpHeaders headers, Map<String, Object> body, String id, @Nullable Locale locale) {
        this(uri, headers, null, Collections.emptyMap(), body, id, locale);
    }

    public WebGraphQlRequest(URI uri, HttpHeaders headers, @Nullable MultiValueMap<String, HttpCookie> cookies, Map<String, Object> attributes, Map<String, Object> body, String id, @Nullable Locale locale) {
        super(WebGraphQlRequest.getQuery(body), WebGraphQlRequest.getOperation(body), WebGraphQlRequest.getMap("variables", body), WebGraphQlRequest.getMap("extensions", body), id, locale);
        Assert.notNull((Object)uri, (String)"URI is required'");
        Assert.notNull((Object)headers, (String)"HttpHeaders is required'");
        this.uri = UriComponentsBuilder.fromUri((URI)uri).build(true);
        this.headers = headers;
        this.cookies = cookies != null ? CollectionUtils.unmodifiableMultiValueMap(cookies) : EMPTY_COOKIES;
        this.attributes = Collections.unmodifiableMap(attributes);
    }

    private static String getQuery(Map<String, Object> body) {
        String query;
        Object value = body.get("query");
        if (!(value instanceof String) || !StringUtils.hasText((String)(query = (String)value))) {
            throw new ServerWebInputException("Invalid value for 'query'");
        }
        return (String)value;
    }

    @Nullable
    private static String getOperation(Map<String, Object> body) {
        Object value = body.get("operationName");
        if (value != null && !(value instanceof String)) {
            throw new ServerWebInputException("Invalid value for 'operationName'");
        }
        return (String)value;
    }

    @Nullable
    private static Map<String, Object> getMap(String key, Map<String, Object> body) {
        Object value = body.get(key);
        if (value != null && !(value instanceof Map)) {
            throw new ServerWebInputException("Invalid value for '" + key + "'");
        }
        return (Map)value;
    }

    public UriComponents getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.cookies;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

