/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.graphql.data.pagination.Subrange;
import org.springframework.lang.Nullable;

public final class ScrollSubrange
extends Subrange<ScrollPosition> {
    private ScrollSubrange(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward, @Nullable Object unused) {
        super(pos, count, forward);
    }

    @Deprecated(since="1.2.4", forRemoval=true)
    public ScrollSubrange(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward) {
        super(ScrollSubrange.initPosition(pos, count, forward), count, pos instanceof OffsetScrollPosition || forward);
    }

    @Nullable
    private static ScrollPosition initPosition(@Nullable ScrollPosition pos, @Nullable Integer count, boolean forward) {
        if (!forward) {
            if (pos instanceof OffsetScrollPosition) {
                OffsetScrollPosition offsetPosition = (OffsetScrollPosition)pos;
                if (count != null) {
                    return offsetPosition.advanceBy((long)(-count.intValue()));
                }
            }
            if (pos instanceof KeysetScrollPosition) {
                KeysetScrollPosition keysetPosition = (KeysetScrollPosition)pos;
                pos = keysetPosition.backward();
            }
        }
        return pos;
    }

    public static ScrollSubrange create(@Nullable ScrollPosition position, @Nullable Integer count, boolean forward) {
        if (position instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)position;
            return ScrollSubrange.initFromOffsetPosition(offsetScrollPosition, count, forward);
        }
        if (position instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)position;
            return ScrollSubrange.initFromKeysetPosition(keysetScrollPosition, count, forward);
        }
        return new ScrollSubrange(position, count, forward, null);
    }

    private static ScrollSubrange initFromOffsetPosition(OffsetScrollPosition position, @Nullable Integer count, boolean forward) {
        if (!forward) {
            if (count != null) {
                if (position.getOffset() == 0L) {
                    count = 0;
                } else if ((long)count.intValue() >= position.getOffset()) {
                    count = (int)(position.getOffset() - 1L);
                }
                position = position.advanceBy((long)(-count.intValue() - 1));
            }
            forward = true;
        }
        return new ScrollSubrange((ScrollPosition)position, count, forward, null);
    }

    private static ScrollSubrange initFromKeysetPosition(KeysetScrollPosition position, @Nullable Integer count, boolean forward) {
        if (!forward) {
            position = position.backward();
        }
        return new ScrollSubrange((ScrollPosition)position, count, forward, null);
    }
}

