/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.observation;

import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationCreateStateParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import org.springframework.graphql.observation.DataFetcherObservationContext;
import org.springframework.graphql.observation.DataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultDataFetcherObservationConvention;
import org.springframework.graphql.observation.DefaultExecutionRequestObservationConvention;
import org.springframework.graphql.observation.ExecutionRequestObservationContext;
import org.springframework.graphql.observation.ExecutionRequestObservationConvention;
import org.springframework.graphql.observation.GraphQlObservationDocumentation;
import org.springframework.lang.Nullable;

public class GraphQlObservationInstrumentation
extends SimplePerformantInstrumentation {
    private static final ExecutionRequestObservationConvention DEFAULT_REQUEST_CONVENTION = new DefaultExecutionRequestObservationConvention();
    private static final DataFetcherObservationConvention DEFAULT_DATA_FETCHER_CONVENTION = new DefaultDataFetcherObservationConvention();
    private final ObservationRegistry observationRegistry;
    private final ExecutionRequestObservationConvention requestObservationConvention;
    private final DataFetcherObservationConvention dataFetcherObservationConvention;

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = new DefaultExecutionRequestObservationConvention();
        this.dataFetcherObservationConvention = new DefaultDataFetcherObservationConvention();
    }

    public GraphQlObservationInstrumentation(ObservationRegistry observationRegistry, ExecutionRequestObservationConvention requestObservationConvention, DataFetcherObservationConvention dateFetcherObservationConvention) {
        this.observationRegistry = observationRegistry;
        this.requestObservationConvention = requestObservationConvention;
        this.dataFetcherObservationConvention = dateFetcherObservationConvention;
    }

    public InstrumentationState createState(InstrumentationCreateStateParameters parameters) {
        return RequestObservationInstrumentationState.INSTANCE;
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters, InstrumentationState state) {
        if (state == RequestObservationInstrumentationState.INSTANCE) {
            final ExecutionRequestObservationContext observationContext = new ExecutionRequestObservationContext(parameters.getExecutionInput());
            final Observation requestObservation = GraphQlObservationDocumentation.EXECUTION_REQUEST.observation(this.requestObservationConvention, DEFAULT_REQUEST_CONVENTION, () -> observationContext, this.observationRegistry);
            GraphQlObservationInstrumentation.setCurrentObservation(requestObservation, parameters.getGraphQLContext());
            requestObservation.start();
            return new SimpleInstrumentationContext<ExecutionResult>(){

                public void onCompleted(ExecutionResult result, Throwable exc) {
                    observationContext.setExecutionResult(result);
                    if (exc != null) {
                        requestObservation.error(exc);
                    }
                    requestObservation.stop();
                }
            };
        }
        return super.beginExecution(parameters, state);
    }

    private static void setCurrentObservation(Observation currentObservation, GraphQLContext graphQlContext) {
        Observation parentObservation = (Observation)graphQlContext.get((Object)"micrometer.observation");
        currentObservation.parentObservation(parentObservation);
        graphQlContext.put((Object)"micrometer.observation", (Object)currentObservation);
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters, InstrumentationState state) {
        if (!parameters.isTrivialDataFetcher() && state == RequestObservationInstrumentationState.INSTANCE) {
            return environment -> {
                DataFetcherObservationContext observationContext = new DataFetcherObservationContext(environment);
                Observation dataFetcherObservation = GraphQlObservationDocumentation.DATA_FETCHER.observation(this.dataFetcherObservationConvention, DEFAULT_DATA_FETCHER_CONVENTION, () -> observationContext, this.observationRegistry);
                dataFetcherObservation.parentObservation(GraphQlObservationInstrumentation.getCurrentObservation(environment));
                dataFetcherObservation.start();
                DataFetchingEnvironment dataFetchingEnvironment = GraphQlObservationInstrumentation.wrapDataFetchingEnvironment(environment, dataFetcherObservation);
                try {
                    Object value = dataFetcher.get(dataFetchingEnvironment);
                    if (value instanceof CompletionStage) {
                        CompletionStage completion = (CompletionStage)value;
                        return completion.handle((result, error) -> {
                            observationContext.setValue(result);
                            if (error != null) {
                                if (error instanceof CompletionException) {
                                    CompletionException completionException = (CompletionException)error;
                                    dataFetcherObservation.error(error.getCause());
                                    dataFetcherObservation.stop();
                                    throw completionException;
                                }
                                dataFetcherObservation.error(error);
                                dataFetcherObservation.stop();
                                throw new CompletionException((Throwable)error);
                            }
                            dataFetcherObservation.stop();
                            return result;
                        });
                    }
                    observationContext.setValue(value);
                    dataFetcherObservation.stop();
                    return value;
                }
                catch (Throwable throwable) {
                    dataFetcherObservation.error(throwable);
                    dataFetcherObservation.stop();
                    throw throwable;
                }
            };
        }
        return dataFetcher;
    }

    @Nullable
    private static Observation getCurrentObservation(DataFetchingEnvironment environment) {
        Observation currentObservation = null;
        Object object = environment.getLocalContext();
        if (object instanceof GraphQLContext) {
            GraphQLContext localContext = (GraphQLContext)object;
            currentObservation = (Observation)localContext.get((Object)"micrometer.observation");
        }
        if (currentObservation == null) {
            currentObservation = (Observation)environment.getGraphQlContext().get((Object)"micrometer.observation");
        }
        return currentObservation;
    }

    private static DataFetchingEnvironment wrapDataFetchingEnvironment(DataFetchingEnvironment environment, Observation dataFetcherObservation) {
        GraphQLContext.Builder localContextBuilder = GraphQLContext.newContext();
        Object object = environment.getLocalContext();
        if (object instanceof GraphQLContext) {
            GraphQLContext localContext = (GraphQLContext)object;
            localContextBuilder.of(localContext);
        }
        localContextBuilder.of((Object)"micrometer.observation", (Object)dataFetcherObservation);
        return DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)environment).localContext((Object)localContextBuilder.build()).build();
    }

    static class RequestObservationInstrumentationState
    implements InstrumentationState {
        static final RequestObservationInstrumentationState INSTANCE = new RequestObservationInstrumentationState();

        RequestObservationInstrumentationState() {
        }
    }
}

