/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.client.autoconfigure;

import io.micrometer.core.instrument.binder.grpc.GrpcClientObservationConvention;
import io.micrometer.core.instrument.binder.grpc.ObservationGrpcClientInterceptor;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.grpc.client.autoconfigure.ConditionalOnGrpcClientEnabled;
import org.springframework.context.annotation.Bean;
import org.springframework.grpc.client.GlobalClientInterceptor;

@AutoConfiguration(afterName={"org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration"})
@ConditionalOnGrpcClientEnabled
@ConditionalOnClass(value={ObservationRegistry.class, ObservationGrpcClientInterceptor.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnProperty(name={"spring.grpc.client.observation.enabled"}, havingValue="true", matchIfMissing=true)
public final class GrpcClientObservationAutoConfiguration {
    @Bean
    @GlobalClientInterceptor
    @ConditionalOnMissingBean
    ObservationGrpcClientInterceptor observationGrpcClientInterceptor(ObservationRegistry observationRegistry, ObjectProvider<GrpcClientObservationConvention> convention) {
        ObservationGrpcClientInterceptor interceptor = new ObservationGrpcClientInterceptor(observationRegistry);
        if (convention.getIfAvailable() != null) {
            interceptor.setCustomConvention((GrpcClientObservationConvention)convention.getIfAvailable());
        }
        return interceptor;
    }
}

