/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.grpc.server.autoconfigure;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.grpc.server.autoconfigure.ConditionalOnGrpcServerEnabled;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnEnabledGrpcServerCondition
extends SpringBootCondition {
    private static final String SERVER_PROPERTY = "spring.grpc.server.enabled";
    private static final String SERVICE_PROPERTY = "spring.grpc.server.%s.enabled";

    OnEnabledGrpcServerCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Boolean serviceEnabled;
        Boolean serverEnabled = (Boolean)context.getEnvironment().getProperty(SERVER_PROPERTY, Boolean.class);
        if (serverEnabled != null && !serverEnabled.booleanValue()) {
            return new ConditionOutcome(serverEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnGrpcServerEnabled.class, (Object[])new Object[0]).because("spring.grpc.server.enabled is " + serverEnabled));
        }
        String serviceName = OnEnabledGrpcServerCondition.getServiceName(metadata);
        if (StringUtils.hasLength((String)serviceName) && (serviceEnabled = (Boolean)context.getEnvironment().getProperty(SERVICE_PROPERTY.formatted(serviceName), Boolean.class)) != null) {
            return new ConditionOutcome(serviceEnabled.booleanValue(), ConditionMessage.forCondition(ConditionalOnGrpcServerEnabled.class, (Object[])new Object[0]).because(SERVICE_PROPERTY.formatted(serviceName) + " is " + serviceEnabled));
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnGrpcServerEnabled.class, (Object[])new Object[0]).because("server and service are enabled by default"));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @Nullable String getServiceName(AnnotatedTypeMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnGrpcServerEnabled.class.getName());
        if (attributes == null) {
            return null;
        }
        return (String)attributes.get("value");
    }
}

