/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.client;

import io.grpc.ChannelCredentials;
import io.grpc.InsecureChannelCredentials;
import io.grpc.TlsChannelCredentials;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.grpc.autoconfigure.client.GrpcClientProperties;
import org.springframework.grpc.client.ChannelCredentialsProvider;
import org.springframework.grpc.client.NegotiationType;
import org.springframework.grpc.internal.InsecureTrustManagerFactory;

public class NamedChannelCredentialsProvider
implements ChannelCredentialsProvider {
    private final SslBundles bundles;
    private final GrpcClientProperties properties;

    public NamedChannelCredentialsProvider(SslBundles bundles, GrpcClientProperties properties) {
        this.bundles = bundles;
        this.properties = properties;
    }

    public ChannelCredentials getChannelCredentials(String path) {
        SslBundle bundle;
        GrpcClientProperties.ChannelConfig channel = this.properties.getChannel(path);
        if (!channel.getSsl().isEnabled() && channel.getNegotiationType() == NegotiationType.PLAINTEXT) {
            return InsecureChannelCredentials.create();
        }
        SslBundle sslBundle = bundle = channel.getSsl().isEnabled() ? this.bundles.getBundle(channel.getSsl().getBundle()) : null;
        if (bundle != null) {
            TrustManagerFactory trustManagers = channel.isSecure() ? bundle.getManagers().getTrustManagerFactory() : InsecureTrustManagerFactory.INSTANCE;
            return TlsChannelCredentials.newBuilder().keyManager(bundle.getManagers().getKeyManagerFactory().getKeyManagers()).trustManager(trustManagers.getTrustManagers()).build();
        }
        if (channel.isSecure()) {
            return TlsChannelCredentials.create();
        }
        return TlsChannelCredentials.newBuilder().trustManager(InsecureTrustManagerFactory.INSTANCE.getTrustManagers()).build();
    }
}

