/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.grpc.autoconfigure.server.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.grpc.autoconfigure.server.GrpcServerFactoryAutoConfiguration;
import org.springframework.grpc.server.security.GrpcSecurity;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;

@ConditionalOnBean(value={ObjectPostProcessor.class})
@Configuration(proxyBeanMethods=false)
@Conditional(value={GrpcServerFactoryAutoConfiguration.OnNativeGrpcServerCondition.class})
class GrpcNativeSecurityConfigurerAutoConfiguration {
    GrpcNativeSecurityConfigurerAutoConfiguration() {
    }

    @Bean
    public GrpcSecurity grpcSecurity(ObjectPostProcessor<Object> objectPostProcessor, AuthenticationConfiguration authenticationConfiguration, ApplicationContext context) throws Exception {
        AuthenticationManagerBuilder authenticationManagerBuilder = authenticationConfiguration.authenticationManagerBuilder(objectPostProcessor, context);
        authenticationManagerBuilder.parentAuthenticationManager(authenticationConfiguration.getAuthenticationManager());
        return new GrpcSecurity(objectPostProcessor, authenticationManagerBuilder, context);
    }
}

