/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import com.google.inject.BindingAnnotation;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.ContextAnnotationAutowireCandidateResolver;
import org.springframework.util.Assert;

class GuiceAutowireCandidateResolver
extends ContextAnnotationAutowireCandidateResolver {
    private Provider<Injector> injectorProvider;
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    GuiceAutowireCandidateResolver(Provider<Injector> injectorProvider) {
        this.injectorProvider = injectorProvider;
        this.addQualifierType(BindingAnnotation.class);
    }

    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        return this.isLazy(descriptor, beanName) ? this.buildLazyResolutionProxy(descriptor, beanName) : null;
    }

    protected boolean isLazy(DependencyDescriptor descriptor, String beanName) {
        Assert.state((boolean)(this.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"BeanFactory needs to be a DefaultListableBeanFactory");
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        if (this.isCollectionType(descriptor.getDependencyType())) {
            return false;
        }
        if (super.isLazy(descriptor)) {
            return true;
        }
        try {
            beanFactory.doResolveDependency(descriptor, beanName, null, null);
        }
        catch (NoSuchBeanDefinitionException ex) {
            if (ex.getResolvableType() != null) {
                this.logger.debug((Object)String.format("Using just in time binding for %s in bean: %s", ex.getResolvableType().getType().getTypeName(), beanName));
            }
            return true;
        }
        return false;
    }

    protected Object buildLazyResolutionProxy(final DependencyDescriptor descriptor, final String beanName) {
        Assert.state((boolean)(this.getBeanFactory() instanceof DefaultListableBeanFactory), (String)"BeanFactory needs to be a DefaultListableBeanFactory");
        final DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.getBeanFactory();
        TargetSource ts = new TargetSource(){
            private Optional<Boolean> isGuiceResolvable = Optional.empty();

            public Class<?> getTargetClass() {
                return descriptor.getDependencyType();
            }

            public boolean isStatic() {
                return false;
            }

            public Object getTarget() {
                Object target = null;
                if (this.isGuiceResolvable.isPresent() && this.isGuiceResolvable.get().booleanValue()) {
                    target = this.targetGuiceObject();
                } else {
                    try {
                        target = beanFactory.doResolveDependency(descriptor, beanName, null, null);
                    }
                    catch (NoSuchBeanDefinitionException ex) {
                        target = this.targetGuiceObject();
                        this.isGuiceResolvable = Optional.of(true);
                    }
                }
                if (target == null) {
                    throw new NoSuchBeanDefinitionException(descriptor.getDependencyType(), "Optional dependency not present for lazy injection point");
                }
                return target;
            }

            private Object targetGuiceObject() {
                Key<?> key = this.guiceInstanceResolverKey();
                return ((Injector)GuiceAutowireCandidateResolver.this.injectorProvider.get()).getInstance(key);
            }

            private Key<?> guiceInstanceResolverKey() {
                Type type = descriptor.getResolvableType().getType();
                Qualifier qualifierValue = this.qualifierBean(descriptor);
                if (qualifierValue != null) {
                    return Key.get((Type)type, (Annotation)Names.named((String)qualifierValue.value()));
                }
                return Key.get((Type)type);
            }

            private Qualifier qualifierBean(DependencyDescriptor descriptor2) {
                if (descriptor2.getField() != null) {
                    return descriptor2.getField().getAnnotation(Qualifier.class);
                }
                if (descriptor2.getMethodParameter() != null) {
                    return (Qualifier)descriptor2.getMethodParameter().getParameterAnnotation(Qualifier.class);
                }
                return null;
            }

            public void releaseTarget(Object target) {
            }
        };
        try {
            ProxyFactory pf = new ProxyFactory();
            pf.setTargetSource(ts);
            Class dependencyType = descriptor.getDependencyType();
            if (dependencyType.isInterface()) {
                pf.addInterface(dependencyType);
            }
            return pf.getProxy(beanFactory.getBeanClassLoader());
        }
        catch (Exception ex) {
            this.logger.debug((Object)"Failed to build lazy resolution proxy to Guice", (Throwable)ex);
            return null;
        }
    }

    private boolean isCollectionType(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || Map.class == type;
    }
}

