/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.guice.module;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.guice.module.BindingTypeMatcher;
import org.springframework.util.PatternMatchUtils;

public class GuiceModuleMetadata
implements BindingTypeMatcher {
    private TypeFilter[] includeFilters;
    private TypeFilter[] excludeFilters;
    private Pattern[] includePatterns;
    private Pattern[] excludePatterns;
    private String[] includeNames;
    private String[] excludeNames;
    private Set<Class<?>> infrastructureTypes = new HashSet();
    private MetadataReaderFactory metadataReaderFactory;

    public GuiceModuleMetadata() {
        this.infrastructureTypes.add(InitializingBean.class);
        this.infrastructureTypes.add(DisposableBean.class);
        this.metadataReaderFactory = new CachingMetadataReaderFactory();
    }

    public GuiceModuleMetadata include(String ... filters) {
        this.includeNames = filters;
        return this;
    }

    public GuiceModuleMetadata exclude(String ... filters) {
        this.excludeNames = filters;
        return this;
    }

    public GuiceModuleMetadata include(Pattern ... filters) {
        this.includePatterns = filters;
        return this;
    }

    public GuiceModuleMetadata exclude(Pattern ... filters) {
        this.excludePatterns = filters;
        return this;
    }

    public GuiceModuleMetadata include(TypeFilter ... filters) {
        this.includeFilters = filters;
        return this;
    }

    public GuiceModuleMetadata exclude(TypeFilter ... filters) {
        this.excludeFilters = filters;
        return this;
    }

    @Override
    public boolean matches(String name, Type type) {
        Type rawType = type instanceof ParameterizedType ? ((ParameterizedType)type).getRawType() : type;
        return this.matches(name) && this.matches(rawType);
    }

    private boolean matches(String name) {
        if (this.includePatterns != null) {
            for (Pattern filter : this.includePatterns) {
                if (filter.matcher(name).matches()) continue;
                return false;
            }
        }
        if (this.excludePatterns != null) {
            for (Pattern filter : this.excludePatterns) {
                if (!filter.matcher(name).matches()) continue;
                return false;
            }
        }
        if (this.includeNames != null && this.includeNames.length > 0 && !PatternMatchUtils.simpleMatch((String[])this.includeNames, (String)name)) {
            return false;
        }
        if (this.excludeNames != null && this.excludeNames.length > 0) {
            return !PatternMatchUtils.simpleMatch((String[])this.excludeNames, (String)name);
        }
        return true;
    }

    private boolean matches(Type type) {
        MetadataReader reader;
        if (this.infrastructureTypes.contains(type)) {
            return false;
        }
        if (!this.visible(type)) {
            return false;
        }
        if (this.includeFilters != null) {
            try {
                reader = this.metadataReaderFactory.getMetadataReader(type.getTypeName());
                for (TypeFilter filter : this.includeFilters) {
                    if (filter.match(reader, this.metadataReaderFactory)) continue;
                    return false;
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read metadata for class " + type, ex);
            }
        }
        if (this.excludeFilters != null) {
            try {
                reader = this.metadataReaderFactory.getMetadataReader(type.getTypeName());
                for (TypeFilter filter : this.excludeFilters) {
                    if (!filter.match(reader, this.metadataReaderFactory)) continue;
                    return false;
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read metadata for class " + type, ex);
            }
        }
        return true;
    }

    private boolean visible(Type type) {
        for (Class<?> cls = ResolvableType.forType((Type)type).resolve(); cls != null && cls != Object.class; cls = cls.getDeclaringClass()) {
            if (Modifier.isInterface(cls.getModifiers()) || Modifier.isPublic(cls.getModifiers()) || Modifier.isProtected(cls.getModifiers())) continue;
            return false;
        }
        return true;
    }
}

