/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.reflect.Method;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilder
extends LinkBuilderSupport<ControllerLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(RequestMapping.class);
    private static final ControllerLinkBuilderFactory FACTORY = new ControllerLinkBuilderFactory();

    ControllerLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        Assert.notNull(controller);
        ControllerLinkBuilder builder = new ControllerLinkBuilder(ControllerLinkBuilder.getBuilder());
        String mapping = DISCOVERER.getMapping(controller);
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping)).build();
        UriComponents expandedComponents = uriComponents.expand(parameters);
        return (ControllerLinkBuilder)builder.slash(expandedComponents);
    }

    public static ControllerLinkBuilder linkTo(Method method, Object ... parameters) {
        UriTemplate template = new UriTemplate(DISCOVERER.getMapping(method));
        URI uri = template.expand(parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(ControllerLinkBuilder.getBuilder()).slash(uri);
    }

    public static ControllerLinkBuilder linkTo(Object invocationValue) {
        return FACTORY.linkTo(invocationValue);
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected ControllerLinkBuilder getThis() {
        return this;
    }

    @Override
    protected ControllerLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new ControllerLinkBuilder(builder);
    }

    public UriComponentsBuilder toUriComponentsBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.toUri());
    }

    static UriComponentsBuilder getBuilder() {
        String host;
        HttpServletRequest request = ControllerLinkBuilder.getCurrentRequest();
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request);
        String forwardedSsl = request.getHeader("X-Forwarded-Ssl");
        if (StringUtils.hasText((String)forwardedSsl) && forwardedSsl.equalsIgnoreCase("on")) {
            builder.scheme("https");
        }
        if (!StringUtils.hasText((String)(host = request.getHeader("X-Forwarded-Host")))) {
            return builder;
        }
        String[] hosts = StringUtils.commaDelimitedListToStringArray((String)host);
        String hostToUse = hosts[0];
        if (hostToUse.contains(":")) {
            String[] hostAndPort = StringUtils.split((String)hostToUse, (String)":");
            builder.host(hostAndPort[0]);
            builder.port(Integer.parseInt(hostAndPort[1]));
        } else {
            builder.host(hostToUse);
            builder.port(-1);
        }
        String port = request.getHeader("X-Forwarded-Port");
        if (StringUtils.hasText((String)port)) {
            builder.port(Integer.parseInt(port));
        }
        return builder;
    }

    private static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)"Could not find current request via RequestContextHolder");
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }
}

