/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.UriTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@XmlType(name="link", namespace="http://www.w3.org/2005/Atom")
@JsonIgnoreProperties(value={"templated"})
public class Link
implements Serializable {
    private static final long serialVersionUID = -9037755944661782121L;
    private static final String URI_PATTERN = "(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String REL_SELF = "self";
    public static final String REL_FIRST = "first";
    public static final String REL_PREVIOUS = "prev";
    public static final String REL_NEXT = "next";
    public static final String REL_LAST = "last";
    @XmlAttribute
    private String rel;
    @XmlAttribute
    private String href;
    @XmlAttribute
    private String hreflang;
    @XmlAttribute
    private String media;
    @XmlAttribute
    private String title;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String deprecation;
    @XmlTransient
    @JsonIgnore
    private UriTemplate template;

    public Link(String href) {
        this(href, REL_SELF);
    }

    public Link(String href, String rel) {
        this(new UriTemplate(href), rel);
    }

    public Link(UriTemplate template, String rel) {
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.hasText((String)rel, (String)"Rel must not be null or empty!");
        this.template = template;
        this.href = template.toString();
        this.rel = rel;
    }

    public Link withSelfRel() {
        return this.withRel(REL_SELF);
    }

    @JsonIgnore
    public List<String> getVariableNames() {
        return this.getUriTemplate().getVariableNames();
    }

    @JsonIgnore
    public List<TemplateVariable> getVariables() {
        return this.getUriTemplate().getVariables();
    }

    public boolean isTemplated() {
        return !this.getUriTemplate().getVariables().isEmpty();
    }

    public Link expand(Object ... arguments) {
        return new Link(this.getUriTemplate().expand(arguments).toString(), this.getRel());
    }

    public Link expand(Map<String, ? extends Object> arguments) {
        return new Link(this.getUriTemplate().expand(arguments).toString(), this.getRel());
    }

    private UriTemplate getUriTemplate() {
        if (this.template == null) {
            this.template = new UriTemplate(this.href);
        }
        return this.template;
    }

    public String toString() {
        String linkString = String.format("<%s>;rel=\"%s\"", this.href, this.rel);
        if (this.hreflang != null) {
            linkString = linkString + ";hreflang=\"" + this.hreflang + "\"";
        }
        if (this.media != null) {
            linkString = linkString + ";media=\"" + this.media + "\"";
        }
        if (this.title != null) {
            linkString = linkString + ";title=\"" + this.title + "\"";
        }
        if (this.type != null) {
            linkString = linkString + ";type=\"" + this.type + "\"";
        }
        if (this.deprecation != null) {
            linkString = linkString + ";deprecation=\"" + this.deprecation + "\"";
        }
        return linkString;
    }

    public static Link valueOf(String element) {
        if (!StringUtils.hasText((String)element)) {
            return null;
        }
        Pattern uriAndAttributes = Pattern.compile("<(.*)>;(.*)");
        Matcher matcher = uriAndAttributes.matcher(element);
        if (matcher.find()) {
            Map<String, String> attributes = Link.getAttributeMap(matcher.group(2));
            if (!attributes.containsKey("rel")) {
                throw new IllegalArgumentException("Link does not provide a rel attribute!");
            }
            Link link = new Link(matcher.group(1), attributes.get("rel"));
            if (attributes.containsKey("hreflang")) {
                link = link.withHreflang(attributes.get("hreflang"));
            }
            if (attributes.containsKey("media")) {
                link = link.withMedia(attributes.get("media"));
            }
            if (attributes.containsKey("title")) {
                link = link.withTitle(attributes.get("title"));
            }
            if (attributes.containsKey("type")) {
                link = link.withType(attributes.get("type"));
            }
            if (attributes.containsKey("deprecation")) {
                link = link.withDeprecation(attributes.get("deprecation"));
            }
            return link;
        }
        throw new IllegalArgumentException(String.format("Given link header %s is not RFC5988 compliant!", element));
    }

    private static Map<String, String> getAttributeMap(String source) {
        if (!StringUtils.hasText((String)source)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        Pattern keyAndValue = Pattern.compile("(\\w+)=\"(\\p{Lower}[\\p{Lower}\\p{Digit}\\.\\-\\s]*|(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|])\"");
        Matcher matcher = keyAndValue.matcher(source);
        while (matcher.find()) {
            attributes.put(matcher.group(1), matcher.group(2));
        }
        return attributes;
    }

    protected Link() {
    }

    Link(String rel, String href, String hreflang, String media, String title, String type, String deprecation, UriTemplate template) {
        this.rel = rel;
        this.href = href;
        this.hreflang = hreflang;
        this.media = media;
        this.title = title;
        this.type = type;
        this.deprecation = deprecation;
        this.template = template;
    }

    public String getRel() {
        return this.rel;
    }

    public String getHref() {
        return this.href;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public String getMedia() {
        return this.media;
    }

    public String getTitle() {
        return this.title;
    }

    public String getType() {
        return this.type;
    }

    public String getDeprecation() {
        return this.deprecation;
    }

    public UriTemplate getTemplate() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rel = this.getRel();
        String other$rel = other.getRel();
        if (this$rel == null ? other$rel != null : !this$rel.equals(other$rel)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$hreflang = this.getHreflang();
        String other$hreflang = other.getHreflang();
        if (this$hreflang == null ? other$hreflang != null : !this$hreflang.equals(other$hreflang)) {
            return false;
        }
        String this$media = this.getMedia();
        String other$media = other.getMedia();
        if (this$media == null ? other$media != null : !this$media.equals(other$media)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$deprecation = this.getDeprecation();
        String other$deprecation = other.getDeprecation();
        return !(this$deprecation == null ? other$deprecation != null : !this$deprecation.equals(other$deprecation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : $rel.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $hreflang = this.getHreflang();
        result = result * 59 + ($hreflang == null ? 43 : $hreflang.hashCode());
        String $media = this.getMedia();
        result = result * 59 + ($media == null ? 43 : $media.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $deprecation = this.getDeprecation();
        result = result * 59 + ($deprecation == null ? 43 : $deprecation.hashCode());
        return result;
    }

    public Link withRel(String rel) {
        return this.rel == rel ? this : new Link(rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.template);
    }

    public Link withHref(String href) {
        return this.href == href ? this : new Link(this.rel, href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.template);
    }

    public Link withHreflang(String hreflang) {
        return this.hreflang == hreflang ? this : new Link(this.rel, this.href, hreflang, this.media, this.title, this.type, this.deprecation, this.template);
    }

    public Link withMedia(String media) {
        return this.media == media ? this : new Link(this.rel, this.href, this.hreflang, media, this.title, this.type, this.deprecation, this.template);
    }

    public Link withTitle(String title) {
        return this.title == title ? this : new Link(this.rel, this.href, this.hreflang, this.media, title, this.type, this.deprecation, this.template);
    }

    public Link withType(String type) {
        return this.type == type ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, type, this.deprecation, this.template);
    }

    public Link withDeprecation(String deprecation) {
        return this.deprecation == deprecation ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, deprecation, this.template);
    }
}

