/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.core.ControllerEntityLinksFactoryBean;
import org.springframework.hateoas.core.DelegatingEntityLinks;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.stereotype.Controller;

@Configuration
class EntityLinksConfiguration {
    EntityLinksConfiguration() {
    }

    @Bean
    PluginRegistryFactoryBean<EntityLinks, Class<?>> entityLinksPluginRegistry() {
        PluginRegistryFactoryBean registry = new PluginRegistryFactoryBean();
        registry.setType(EntityLinks.class);
        registry.setExclusions(new Class[]{DelegatingEntityLinks.class});
        return registry;
    }

    @Primary
    @Bean
    @DependsOn(value={"controllerEntityLinks"})
    DelegatingEntityLinks delegatingEntityLinks(PluginRegistry<EntityLinks, Class<?>> entityLinksPluginRegistry) {
        return new DelegatingEntityLinks(entityLinksPluginRegistry);
    }

    @Bean
    ControllerEntityLinksFactoryBean controllerEntityLinks(ControllerLinkBuilderFactory controllerLinkBuilderFactory) {
        ControllerEntityLinksFactoryBean factory = new ControllerEntityLinksFactoryBean();
        factory.setAnnotation(Controller.class);
        factory.setLinkBuilderFactory(controllerLinkBuilderFactory);
        return factory;
    }

    @Bean
    ControllerLinkBuilderFactory controllerLinkBuilderFactoryBean() {
        return new ControllerLinkBuilderFactory();
    }
}

