/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.core.AbstractEntityLinks;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DelegatingEntityLinks
extends AbstractEntityLinks {
    private final PluginRegistry<EntityLinks, Class<?>> delegates;

    public DelegatingEntityLinks(PluginRegistry<EntityLinks, Class<?>> plugins) {
        Assert.notNull(plugins, (String)"PluginRegistry must not be null!");
        this.delegates = plugins;
    }

    @Override
    public LinkBuilder linkFor(Class<?> type) {
        return this.getPluginFor(type).linkFor(type);
    }

    @Override
    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.getPluginFor(type).linkFor(type, parameters);
    }

    @Override
    public Link linkToCollectionResource(Class<?> type) {
        return this.getPluginFor(type).linkToCollectionResource(type);
    }

    @Override
    public Link linkToSingleResource(Class<?> type, Object id) {
        return this.getPluginFor(type).linkToSingleResource(type, id);
    }

    public boolean supports(Class<?> delimiter) {
        return this.delegates.hasPluginFor(delimiter);
    }

    private EntityLinks getPluginFor(Class<?> type) {
        EntityLinks plugin = (EntityLinks)this.delegates.getPluginFor(type);
        if (plugin == null) {
            throw new IllegalArgumentException(String.format("Cannot determine link for %s! No EntityLinks instance found supporting the domain type!", type.getName()));
        }
        return plugin;
    }
}

