/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.CachingMappingDiscoverer;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.hateoas.mvc.UriComponentsBuilderFactory;
import org.springframework.hateoas.mvc.UriTemplateFactory;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilder
extends LinkBuilderSupport<ControllerLinkBuilder> {
    private static final CachingMappingDiscoverer DISCOVERER = CachingMappingDiscoverer.of(new AnnotationMappingDiscoverer(RequestMapping.class));
    private static final ControllerLinkBuilderFactory FACTORY = new ControllerLinkBuilderFactory();
    private static final CustomUriTemplateHandler HANDLER = new CustomUriTemplateHandler();
    private final TemplateVariables variables;

    ControllerLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
        this.variables = TemplateVariables.NONE;
    }

    ControllerLinkBuilder(UriComponents uriComponents) {
        this(uriComponents, TemplateVariables.NONE);
    }

    ControllerLinkBuilder(UriComponents uriComponents, TemplateVariables variables) {
        super(uriComponents);
        this.variables = variables;
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        String mapping = DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(UriComponentsBuilderFactory.getBuilder()).slash(uriComponents, true);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        String mapping = DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(UriComponentsBuilderFactory.getBuilder()).slash(uriComponents, true);
    }

    public static ControllerLinkBuilder linkTo(Method method, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(method.getDeclaringClass(), method, parameters);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String mapping = DISCOVERER.getMapping(controller, method);
        UriTemplate template = UriTemplateFactory.templateFor(mapping);
        URI uri = template.expand(parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(UriComponentsBuilderFactory.getBuilder()).slash(uri);
    }

    public static ControllerLinkBuilder linkTo(Object invocationValue) {
        return FACTORY.linkTo(invocationValue);
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected ControllerLinkBuilder getThis() {
        return this;
    }

    @Override
    protected ControllerLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new ControllerLinkBuilder(builder);
    }

    public UriComponentsBuilder toUriComponentsBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.toUri());
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.variables == TemplateVariables.NONE) {
            return result;
        }
        if (!result.contains("#")) {
            return result.concat(this.variables.toString());
        }
        String[] parts = result.split("#");
        return parts[0].concat(this.variables.toString()).concat("#").concat(parts[0]);
    }

    private static class CustomUriTemplateHandler
    extends DefaultUriTemplateHandler {
        public CustomUriTemplateHandler() {
            this.setStrictEncoding(true);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }
    }
}

