/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.jaxrs;

import javax.ws.rs.Path;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class JaxRsLinkBuilder
extends LinkBuilderSupport<JaxRsLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(Path.class);

    private JaxRsLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service) {
        return JaxRsLinkBuilder.linkTo(service, new Object[0]);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service, Object ... parameters) {
        JaxRsLinkBuilder builder = new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping());
        UriTemplate template = new UriTemplate(DISCOVERER.getMapping(service));
        return (JaxRsLinkBuilder)builder.slash(template.expand(parameters));
    }

    @Override
    protected JaxRsLinkBuilder getThis() {
        return this;
    }

    @Override
    protected JaxRsLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new JaxRsLinkBuilder(builder);
    }
}

