/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.util.HashMap;
import java.util.Map;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.hateoas.RelProvider;
import org.springframework.hateoas.core.Relation;

@Order(value=100)
public class AnnotationRelProvider
implements RelProvider {
    private final Map<Class<?>, Relation> annotationCache = new HashMap();

    @Override
    public String getCollectionResourceRelFor(Class<?> type) {
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.collectionRelation())) {
            return null;
        }
        return annotation.collectionRelation();
    }

    @Override
    public String getSingleResourceRelFor(Class<?> type) {
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.value())) {
            return null;
        }
        return annotation.value();
    }

    public boolean supports(Class<?> delimiter) {
        return this.lookupAnnotation(delimiter) != null;
    }

    private Relation lookupAnnotation(Class<?> type) {
        Relation relation = this.annotationCache.get(type);
        if (relation != null) {
            return relation;
        }
        relation = (Relation)AnnotationUtils.getAnnotation(type, Relation.class);
        if (relation != null) {
            this.annotationCache.put(type, relation);
        }
        return relation;
    }
}

