/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.MediaTypeConfigurationProvider;
import org.springframework.http.MediaType;

class HypermediaConfigurationImportSelector
implements ImportSelector {
    HypermediaConfigurationImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        Collection types = Arrays.stream((EnableHypermediaSupport.HypermediaType[])attributes.get("type")).flatMap(it -> it.getMediaTypes().stream()).collect(Collectors.toList());
        List configurationProviders = SpringFactoriesLoader.loadFactories(MediaTypeConfigurationProvider.class, (ClassLoader)HypermediaConfigurationImportSelector.class.getClassLoader());
        if (types.isEmpty()) {
            return configurationProviders.toArray(new String[configurationProviders.size()]);
        }
        return (String[])configurationProviders.stream().filter(it -> it.supportsAny(types)).map(MediaTypeConfigurationProvider::getConfiguration).map(Class::getName).toArray(String[]::new);
    }

    public String[] selectImports(Collection<MediaType> mediaType) {
        return new String[0];
    }
}

