/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;

public class HalLinkRelation
implements LinkRelation,
MessageSourceResolvable {
    public static final HalLinkRelation CURIES = HalLinkRelation.uncuried("curies");
    private static final String RELATION_MESSAGE_TEMPLATE = "_links.%s.title";
    private final String curie;
    @NonNull
    private final String localPart;

    public static HalLinkRelation of(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        if (HalLinkRelation.class.isInstance(relation)) {
            return (HalLinkRelation)HalLinkRelation.class.cast(relation);
        }
        return HalLinkRelation.of(relation.value());
    }

    @JsonCreator
    private static HalLinkRelation of(String relation) {
        String[] split = relation.split(":");
        String curie = split.length == 1 ? null : split[0];
        String localPart = split.length == 1 ? split[0] : split[1];
        return new HalLinkRelation(curie, localPart);
    }

    public static HalLinkRelation curied(String curie, String rel) {
        Assert.hasText((String)curie, (String)"Curie must not be null or empty!");
        return new HalLinkRelation(curie, rel);
    }

    public static HalLinkRelation uncuried(String rel) {
        return new HalLinkRelation(null, rel);
    }

    public static HalLinkRelationBuilder curieBuilder(String curie) {
        return relation -> new HalLinkRelation(curie, relation);
    }

    public HalLinkRelation curie(String curie) {
        Assert.hasText((String)curie, (String)"Curie must not be null or empty!");
        return new HalLinkRelation(curie, this.localPart);
    }

    public HalLinkRelation curieIfUncuried(String curie) {
        Assert.hasText((String)curie, (String)"Curie must not be null or empty!");
        return this.isCuried() || IanaLinkRelations.isIanaRel(this.localPart) ? this : this.curie(curie);
    }

    public boolean isCuried() {
        return this.curie != null;
    }

    @Override
    @JsonValue
    public String value() {
        return this.isCuried() ? String.format("%s:%s", this.curie, this.localPart) : this.localPart;
    }

    public String[] getCodes() {
        return (String[])Stream.of(this.value(), this.localPart).map(it -> String.format(RELATION_MESSAGE_TEMPLATE, it)).toArray(String[]::new);
    }

    public String toString() {
        return this.value();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalLinkRelation)) {
            return false;
        }
        HalLinkRelation other = (HalLinkRelation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$curie = this.curie;
        String other$curie = other.curie;
        if (this$curie == null ? other$curie != null : !this$curie.equals(other$curie)) {
            return false;
        }
        String this$localPart = this.getLocalPart();
        String other$localPart = other.getLocalPart();
        return !(this$localPart == null ? other$localPart != null : !this$localPart.equals(other$localPart));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HalLinkRelation;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $curie = this.curie;
        result = result * 59 + ($curie == null ? 43 : $curie.hashCode());
        String $localPart = this.getLocalPart();
        result = result * 59 + ($localPart == null ? 43 : $localPart.hashCode());
        return result;
    }

    @Generated
    private HalLinkRelation(String curie, @NonNull String localPart) {
        if (localPart == null) {
            throw new IllegalArgumentException("localPart is marked @NonNull but is null");
        }
        this.curie = curie;
        this.localPart = localPart;
    }

    @NonNull
    @Generated
    public String getLocalPart() {
        return this.localPart;
    }

    public static interface HalLinkRelationBuilder {
        public HalLinkRelation relation(String var1);
    }
}

