/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"resource", "resources", "embedded", "links", "templates", "metadata"})
public final class HalFormsDocument<T> {
    @JsonUnwrapped
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final T resource;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnore
    private final Collection<T> resources;
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<HalLinkRelation, Object> embedded;
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final PagedModel.PageMetadata pageMetadata;
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=Jackson2HalModule.HalLinkListSerializer.class)
    @JsonDeserialize(using=Jackson2HalFormsModule.HalFormsLinksDeserializer.class)
    private final Links links;
    @JsonProperty(value="_templates")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, HalFormsTemplate> templates;

    private HalFormsDocument() {
        this(null, null, Collections.emptyMap(), null, Links.NONE, Collections.emptyMap());
    }

    public static <T> HalFormsDocument<T> forResource(T resource) {
        return super.withResource(resource);
    }

    public static <T> HalFormsDocument<T> forResources(Collection<T> resources) {
        Assert.notNull(resources, (String)"Resources must not be null!");
        return super.withResources(resources);
    }

    public static HalFormsDocument<?> empty() {
        return new HalFormsDocument();
    }

    @JsonIgnore
    public HalFormsTemplate getDefaultTemplate() {
        return this.getTemplate("default");
    }

    @JsonIgnore
    public HalFormsTemplate getTemplate(String key) {
        Assert.notNull((Object)key, (String)"Template key must not be null!");
        return this.templates.get(key);
    }

    public HalFormsDocument<T> andLink(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return new HalFormsDocument<T>(this.resource, this.resources, this.embedded, this.pageMetadata, this.links.and(link), this.templates);
    }

    public HalFormsDocument<T> andTemplate(String name, HalFormsTemplate template) {
        Assert.hasText((String)name, (String)"Template name must not be null or empty!");
        Assert.notNull((Object)template, (String)"Template must not be null!");
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>(this.templates);
        templates.put(name, template);
        return new HalFormsDocument<T>(this.resource, this.resources, this.embedded, this.pageMetadata, this.links, templates);
    }

    public HalFormsDocument<T> andEmbedded(HalLinkRelation key, Object value) {
        Assert.notNull((Object)key, (String)"Embedded key must not be null!");
        Assert.notNull((Object)value, (String)"Embedded value must not be null!");
        HashMap<HalLinkRelation, Object> embedded = new HashMap<HalLinkRelation, Object>(this.embedded);
        embedded.put(key, value);
        return new HalFormsDocument<T>(this.resource, this.resources, embedded, this.pageMetadata, this.links, this.templates);
    }

    HalFormsDocument<T> withLinks(Links links) {
        return new HalFormsDocument<T>(this.resource, this.resources, this.embedded, this.pageMetadata, links, this.templates);
    }

    @Generated
    public T getResource() {
        return this.resource;
    }

    @Generated
    public Collection<T> getResources() {
        return this.resources;
    }

    @Generated
    public Map<HalLinkRelation, Object> getEmbedded() {
        return this.embedded;
    }

    @Generated
    public PagedModel.PageMetadata getPageMetadata() {
        return this.pageMetadata;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public Map<String, HalFormsTemplate> getTemplates() {
        return this.templates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalFormsDocument)) {
            return false;
        }
        HalFormsDocument other = (HalFormsDocument)o;
        T this$resource = this.getResource();
        T other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        Collection<T> this$resources = this.getResources();
        Collection<T> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Map<HalLinkRelation, Object> this$embedded = this.getEmbedded();
        Map<HalLinkRelation, Object> other$embedded = other.getEmbedded();
        if (this$embedded == null ? other$embedded != null : !((Object)this$embedded).equals(other$embedded)) {
            return false;
        }
        PagedModel.PageMetadata this$pageMetadata = this.getPageMetadata();
        PagedModel.PageMetadata other$pageMetadata = other.getPageMetadata();
        if (this$pageMetadata == null ? other$pageMetadata != null : !((Object)this$pageMetadata).equals(other$pageMetadata)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        Map<String, HalFormsTemplate> this$templates = this.getTemplates();
        Map<String, HalFormsTemplate> other$templates = other.getTemplates();
        return !(this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        Collection<T> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Map<HalLinkRelation, Object> $embedded = this.getEmbedded();
        result = result * 59 + ($embedded == null ? 43 : ((Object)$embedded).hashCode());
        PagedModel.PageMetadata $pageMetadata = this.getPageMetadata();
        result = result * 59 + ($pageMetadata == null ? 43 : ((Object)$pageMetadata).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        Map<String, HalFormsTemplate> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HalFormsDocument(resource=" + this.getResource() + ", resources=" + this.getResources() + ", embedded=" + this.getEmbedded() + ", pageMetadata=" + this.getPageMetadata() + ", links=" + this.getLinks() + ", templates=" + this.getTemplates() + ")";
    }

    @Generated
    public HalFormsDocument<T> withEmbedded(Map<HalLinkRelation, Object> embedded) {
        return this.embedded == embedded ? this : new HalFormsDocument<T>(this.resource, this.resources, embedded, this.pageMetadata, this.links, this.templates);
    }

    @Generated
    public HalFormsDocument<T> withPageMetadata(PagedModel.PageMetadata pageMetadata) {
        return this.pageMetadata == pageMetadata ? this : new HalFormsDocument<T>(this.resource, this.resources, this.embedded, pageMetadata, this.links, this.templates);
    }

    @Generated
    public HalFormsDocument<T> withTemplates(Map<String, HalFormsTemplate> templates) {
        return this.templates == templates ? this : new HalFormsDocument<T>(this.resource, this.resources, this.embedded, this.pageMetadata, this.links, templates);
    }

    @Generated
    HalFormsDocument(T resource, Collection<T> resources, Map<HalLinkRelation, Object> embedded, PagedModel.PageMetadata pageMetadata, Links links, Map<String, HalFormsTemplate> templates) {
        this.resource = resource;
        this.resources = resources;
        this.embedded = embedded;
        this.pageMetadata = pageMetadata;
        this.links = links;
        this.templates = templates;
    }

    @Generated
    private HalFormsDocument<T> withResource(T resource) {
        return this.resource == resource ? this : new HalFormsDocument<T>(resource, this.resources, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    @Generated
    private HalFormsDocument<T> withResources(Collection<T> resources) {
        return this.resources == resources ? this : new HalFormsDocument<T>(this.resource, resources, this.embedded, this.pageMetadata, this.links, this.templates);
    }
}

