/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.uber.UberData;
import org.springframework.hateoas.mediatype.uber.UberError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
final class Uber {
    private final String version;
    private final List<UberData> data;
    private final UberError error;

    @JsonCreator
    Uber(@JsonProperty(value="version") String version, @JsonProperty(value="data") List<UberData> data, @JsonProperty(value="error") UberError error) {
        this.version = version;
        this.data = data;
        this.error = error;
    }

    Uber() {
        this("1.0", null, null);
    }

    @JsonIgnore
    Links getLinks() {
        return this.data.stream().flatMap(uberData -> uberData.getLinks().stream()).collect(Links.collector());
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public List<UberData> getData() {
        return this.data;
    }

    @Generated
    public UberError getError() {
        return this.error;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Uber)) {
            return false;
        }
        Uber other = (Uber)o;
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        List<UberData> this$data = this.getData();
        List<UberData> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        UberError this$error = this.getError();
        UberError other$error = other.getError();
        return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        List<UberData> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        UberError $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Uber(version=" + this.getVersion() + ", data=" + this.getData() + ", error=" + this.getError() + ")";
    }

    @Generated
    Uber withVersion(String version) {
        return this.version == version ? this : new Uber(version, this.data, this.error);
    }

    @Generated
    Uber withData(List<UberData> data) {
        return this.data == data ? this : new Uber(this.version, data, this.error);
    }

    @Generated
    Uber withError(UberError error) {
        return this.error == error ? this : new Uber(this.version, this.data, error);
    }
}

