/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.uber.UberAction;
import org.springframework.hateoas.mediatype.uber.UberAffordanceModel;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
final class UberData {
    private final String id;
    private final String name;
    private final String label;
    private final List<LinkRelation> rel;
    private final String url;
    private final UberAction action;
    private final boolean transclude;
    private final String model;
    private final List<String> sending;
    private final List<String> accepting;
    private final Object value;
    private final List<UberData> data;
    private static final HashSet<Class<?>> PRIMITIVE_TYPES = new HashSet<Class>(Arrays.asList(String.class));
    private static final HashSet<Class<?>> RESOURCE_TYPES = new HashSet<Class>(Arrays.asList(RepresentationModel.class, EntityModel.class, CollectionModel.class, PagedModel.class));

    @JsonCreator
    UberData(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="label") String label, @JsonProperty(value="rel") List<LinkRelation> rel, @JsonProperty(value="url") String url, @JsonProperty(value="action") UberAction action, @JsonProperty(value="transclude") boolean transclude, @JsonProperty(value="model") String model, @JsonProperty(value="sending") List<String> sending, @JsonProperty(value="accepting") List<String> accepting, @JsonProperty(value="value") Object value, @JsonProperty(value="data") List<UberData> data) {
        this.id = id;
        this.name = name;
        this.label = label;
        this.rel = rel;
        this.url = url;
        this.action = action;
        this.transclude = transclude;
        this.model = model;
        this.sending = sending;
        this.accepting = accepting;
        this.value = value;
        this.data = data;
    }

    UberData() {
        this(null, null, null, null, null, UberAction.READ, false, null, null, null, null, null);
    }

    public UberAction getAction() {
        return this.action == UberAction.READ ? null : this.action;
    }

    public Boolean isTemplated() {
        return Optional.ofNullable(this.url).map(s -> s.contains("{?") ? Boolean.valueOf(true) : null).orElse(null);
    }

    public Boolean isTransclude() {
        return this.transclude ? Boolean.valueOf(this.transclude) : null;
    }

    @JsonIgnore
    public List<Link> getLinks() {
        return Optional.ofNullable(this.rel).map(rels -> rels.stream().map(rel -> new Link(this.url, (LinkRelation)rel)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    static List<UberData> extractLinksAndContent(RepresentationModel<?> resource) {
        List<UberData> data = UberData.extractLinks(resource);
        UberData.extractContent(resource).ifPresent(data::add);
        return data;
    }

    static List<UberData> extractLinksAndContent(EntityModel<?> resource) {
        List<UberData> data = UberData.extractLinks(resource);
        UberData.extractContent(resource.getContent()).ifPresent(data::add);
        return data;
    }

    static List<UberData> extractLinksAndContent(CollectionModel<?> resources) {
        List<UberData> data = UberData.extractLinks(resources);
        data.addAll(resources.getContent().stream().map(UberData::doExtractLinksAndContent).map(uberData -> new UberData().withData((List<UberData>)uberData)).collect(Collectors.toList()));
        return data;
    }

    static List<UberData> extractLinksAndContent(PagedModel<?> resources) {
        List<UberData> collectionOfResources = UberData.extractLinksAndContent(resources);
        if (resources.getMetadata() != null) {
            collectionOfResources.add(new UberData().withName("page").withData(Arrays.asList(new UberData().withName("number").withValue(resources.getMetadata().getNumber()), new UberData().withName("size").withValue(resources.getMetadata().getSize()), new UberData().withName("totalElements").withValue(resources.getMetadata().getTotalElements()), new UberData().withName("totalPages").withValue(resources.getMetadata().getTotalPages()))));
        }
        return collectionOfResources;
    }

    private static List<UberData> extractLinks(Links links) {
        return UberData.urlRelMap(links).entrySet().stream().map(entry -> new UberData().withUrl((String)entry.getKey()).withRel(((LinkAndRels)entry.getValue()).getRels())).collect(Collectors.toList());
    }

    private static List<UberData> extractLinks(RepresentationModel<?> resource) {
        ArrayList<UberData> data = new ArrayList<UberData>();
        List<UberData> links = UberData.extractLinks(resource.getLinks());
        List<UberData> affordanceBasedLinks = UberData.extractAffordances(resource.getLinks());
        if (affordanceBasedLinks.isEmpty()) {
            data.addAll(links);
        } else {
            data.addAll(UberData.mergeDeclaredLinksIntoAffordanceLinks(affordanceBasedLinks, links));
        }
        return data;
    }

    private static Optional<UberData> extractContent(Object content) {
        return Optional.of(content).filter(it -> !RESOURCE_TYPES.contains(content.getClass())).map(it -> new UberData().withName(StringUtils.uncapitalize((String)it.getClass().getSimpleName())).withData(UberData.extractProperties(it)));
    }

    private static List<UberData> doExtractLinksAndContent(Object item) {
        if (item instanceof EntityModel) {
            return UberData.extractLinksAndContent((EntityModel)item);
        }
        if (item instanceof RepresentationModel) {
            return UberData.extractLinksAndContent((RepresentationModel)item);
        }
        return UberData.extractLinksAndContent(new EntityModel<Object>(item, new Link[0]));
    }

    private static Map<String, LinkAndRels> urlRelMap(Links links) {
        LinkedHashMap<String, LinkAndRels> urlRelMap = new LinkedHashMap<String, LinkAndRels>();
        links.forEach(link -> {
            LinkAndRels linkAndRels = urlRelMap.computeIfAbsent(link.getHref(), s -> new LinkAndRels());
            linkAndRels.setLink((Link)link);
            linkAndRels.getRels().add(link.getRel());
        });
        return urlRelMap;
    }

    private static List<UberData> extractAffordances(Links links) {
        return links.stream().flatMap(it -> it.getAffordances().stream()).map(it -> it.getAffordanceModel(MediaTypes.UBER_JSON)).map(UberAffordanceModel.class::cast).map(it -> {
            if (it.hasHttpMethod(HttpMethod.GET)) {
                String suffix = it.getQueryProperties().stream().map(UberData::getName).collect(Collectors.joining(","));
                if (!it.getQueryMethodParameters().isEmpty()) {
                    suffix = "{?" + suffix + "}";
                }
                return new UberData().withName(it.getName()).withRel(Collections.singletonList(LinkRelation.of(it.getName()))).withUrl(it.getLink().expand(new Object[0]).getHref() + suffix).withAction(it.getAction());
            }
            return new UberData().withName(it.getName()).withRel(Collections.singletonList(LinkRelation.of(it.getName()))).withUrl(it.getLink().expand(new Object[0]).getHref()).withModel(it.getInputProperties().stream().map(UberData::getName).map(property -> property + "={" + property + "}").collect(Collectors.joining("&"))).withAction(it.getAction());
        }).collect(Collectors.toList());
    }

    private static List<UberData> mergeDeclaredLinksIntoAffordanceLinks(List<UberData> affordanceBasedLinks, List<UberData> links) {
        return affordanceBasedLinks.stream().flatMap(affordance -> links.stream().filter(link -> link.getUrl().equals(affordance.getUrl())).map(link -> {
            if (link.getAction() == affordance.getAction()) {
                ArrayList<LinkRelation> rels = new ArrayList<LinkRelation>(link.getRel());
                rels.addAll(affordance.getRel());
                return affordance.withName(((LinkRelation)rels.get(0)).value()).withRel(rels);
            }
            return affordance;
        })).collect(Collectors.toList());
    }

    private static List<UberData> extractProperties(Object obj) {
        if (PRIMITIVE_TYPES.contains(obj.getClass())) {
            return Collections.singletonList(new UberData().withValue(obj));
        }
        return PropertyUtils.findProperties(obj).entrySet().stream().map(entry -> new UberData().withName((String)entry.getKey()).withValue(entry.getValue())).collect(Collectors.toList());
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    @Generated
    public List<LinkRelation> getRel() {
        return this.rel;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public List<String> getSending() {
        return this.sending;
    }

    @Generated
    public List<String> getAccepting() {
        return this.accepting;
    }

    @Generated
    public Object getValue() {
        return this.value;
    }

    @Generated
    public List<UberData> getData() {
        return this.data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UberData)) {
            return false;
        }
        UberData other = (UberData)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<LinkRelation> this$rel = this.getRel();
        List<LinkRelation> other$rel = other.getRel();
        if (this$rel == null ? other$rel != null : !((Object)this$rel).equals(other$rel)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        UberAction this$action = this.getAction();
        UberAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        Boolean this$transclude = this.isTransclude();
        Boolean other$transclude = other.isTransclude();
        if (this$transclude == null ? other$transclude != null : !((Object)this$transclude).equals(other$transclude)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<String> this$sending = this.getSending();
        List<String> other$sending = other.getSending();
        if (this$sending == null ? other$sending != null : !((Object)this$sending).equals(other$sending)) {
            return false;
        }
        List<String> this$accepting = this.getAccepting();
        List<String> other$accepting = other.getAccepting();
        if (this$accepting == null ? other$accepting != null : !((Object)this$accepting).equals(other$accepting)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<UberData> this$data = this.getData();
        List<UberData> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<LinkRelation> $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : ((Object)$rel).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        UberAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        Boolean $transclude = this.isTransclude();
        result = result * 59 + ($transclude == null ? 43 : ((Object)$transclude).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<String> $sending = this.getSending();
        result = result * 59 + ($sending == null ? 43 : ((Object)$sending).hashCode());
        List<String> $accepting = this.getAccepting();
        result = result * 59 + ($accepting == null ? 43 : ((Object)$accepting).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<UberData> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UberData(id=" + this.getId() + ", name=" + this.getName() + ", label=" + this.getLabel() + ", rel=" + this.getRel() + ", url=" + this.getUrl() + ", action=" + (Object)((Object)this.getAction()) + ", transclude=" + this.isTransclude() + ", model=" + this.getModel() + ", sending=" + this.getSending() + ", accepting=" + this.getAccepting() + ", value=" + this.getValue() + ", data=" + this.getData() + ")";
    }

    @Generated
    UberData withId(String id) {
        return this.id == id ? this : new UberData(id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withName(String name) {
        return this.name == name ? this : new UberData(this.id, name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withLabel(String label) {
        return this.label == label ? this : new UberData(this.id, this.name, label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withRel(List<LinkRelation> rel) {
        return this.rel == rel ? this : new UberData(this.id, this.name, this.label, rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withUrl(String url) {
        return this.url == url ? this : new UberData(this.id, this.name, this.label, this.rel, url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withAction(UberAction action) {
        return this.action == action ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, action, this.transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withTransclude(boolean transclude) {
        return this.transclude == transclude ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, transclude, this.model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withModel(String model) {
        return this.model == model ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, model, this.sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withSending(List<String> sending) {
        return this.sending == sending ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, sending, this.accepting, this.value, this.data);
    }

    @Generated
    UberData withAccepting(List<String> accepting) {
        return this.accepting == accepting ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, accepting, this.value, this.data);
    }

    @Generated
    UberData withValue(Object value) {
        return this.value == value ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, value, this.data);
    }

    @Generated
    UberData withData(List<UberData> data) {
        return this.data == data ? this : new UberData(this.id, this.name, this.label, this.rel, this.url, this.action, this.transclude, this.model, this.sending, this.accepting, this.value, data);
    }

    private static class LinkAndRels {
        private Link link;
        private List<LinkRelation> rels = new ArrayList<LinkRelation>();

        @Generated
        public LinkAndRels() {
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public List<LinkRelation> getRels() {
            return this.rels;
        }

        @Generated
        public void setLink(Link link) {
            this.link = link;
        }

        @Generated
        public void setRels(List<LinkRelation> rels) {
            this.rels = rels;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LinkAndRels)) {
                return false;
            }
            LinkAndRels other = (LinkAndRels)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            List<LinkRelation> this$rels = this.getRels();
            List<LinkRelation> other$rels = other.getRels();
            return !(this$rels == null ? other$rels != null : !((Object)this$rels).equals(other$rels));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LinkAndRels;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            List<LinkRelation> $rels = this.getRels();
            result = result * 59 + ($rels == null ? 43 : ((Object)$rels).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UberData.LinkAndRels(link=" + this.getLink() + ", rels=" + this.getRels() + ")";
        }
    }
}

