/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;

public class MethodParameters {
    private static ParameterNameDiscoverer DISCOVERER = new DefaultParameterNameDiscoverer();
    private final List<MethodParameter> parameters;
    private final Map<Class<?>, List<MethodParameter>> parametersWithAnnotationCache = new ConcurrentReferenceHashMap();

    public MethodParameters(Method method) {
        this(method, null);
    }

    public MethodParameters(Method method, AnnotationAttribute namingAnnotation) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        this.parameters = IntStream.range(0, method.getParameterTypes().length).mapToObj(it -> new AnnotationNamingMethodParameter(method, it, namingAnnotation)).peek(it -> it.initParameterNameDiscovery(DISCOVERER)).collect(Collectors.toList());
    }

    public List<MethodParameter> getParameters() {
        return this.parameters;
    }

    public Optional<MethodParameter> getParameter(String name) {
        Assert.hasText((String)name, (String)"Parameter name must not be null!");
        return this.getParameters().stream().filter(it -> name.equals(it.getParameterName())).findFirst();
    }

    public List<MethodParameter> getParametersOfType(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        return this.getParameters().stream().filter(it -> it.getParameterType().equals(type)).collect(Collectors.toList());
    }

    public List<MethodParameter> getParametersWith(Class<? extends Annotation> annotation) {
        return this.parametersWithAnnotationCache.computeIfAbsent(annotation, key -> {
            Assert.notNull((Object)annotation, (String)"Annotation must not be null!");
            return this.getParameters().stream().filter(it -> it.hasParameterAnnotation(annotation)).collect(Collectors.toList());
        });
    }

    private static class AnnotationNamingMethodParameter
    extends SynthesizingMethodParameter {
        private final AnnotationAttribute attribute;
        private String name;

        public AnnotationNamingMethodParameter(Method method, int parameterIndex, AnnotationAttribute attribute) {
            super(method, parameterIndex);
            this.attribute = attribute;
        }

        public String getParameterName() {
            String foundName;
            if (this.name != null) {
                return this.name;
            }
            if (this.attribute != null && (foundName = this.attribute.getValueFrom((MethodParameter)this)) != null) {
                this.name = foundName;
                return this.name;
            }
            this.name = super.getParameterName();
            return this.name;
        }
    }
}

