/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;

public class SpringAffordanceBuilder {
    public static List<Affordance> create(MethodInvocation invocation, MappingDiscoverer discoverer, UriComponents components) {
        ArrayList<Affordance> affordances = new ArrayList<Affordance>();
        for (HttpMethod requestMethod : discoverer.getRequestMethod(invocation.getTargetType(), invocation.getMethod())) {
            String methodName = invocation.getMethod().getName();
            String href = components.toUriString().equals("") ? "/" : components.toUriString();
            Link affordanceLink = new Link(href).withRel(LinkRelation.of(methodName));
            MethodParameters invocationMethodParameters = new MethodParameters(invocation.getMethod());
            ResolvableType inputType = invocationMethodParameters.getParametersWith(RequestBody.class).stream().findFirst().map(ResolvableType::forMethodParameter).orElse(ResolvableType.NONE);
            List<QueryParameter> queryMethodParameters = invocationMethodParameters.getParametersWith(RequestParam.class).stream().map(methodParameter -> (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class)).map(requestParam -> new QueryParameter(requestParam.name(), requestParam.value(), requestParam.required())).collect(Collectors.toList());
            ResolvableType outputType = ResolvableType.forMethodReturnType((Method)invocation.getMethod());
            affordances.add(new Affordance(methodName, affordanceLink, requestMethod, inputType, queryMethodParameters, outputType));
        }
        return affordances;
    }
}

