/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class UriTemplate
implements Iterable<TemplateVariable>,
Serializable {
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\{([\\?\\&#/]?)([\\w\\,*]+)\\}");
    private static final long serialVersionUID = -1007874653930162262L;
    private static final Map<String, UriTemplate> CACHE = new ConcurrentHashMap<String, UriTemplate>();
    private final TemplateVariables variables;
    private String toString;
    private String baseUri;

    @Deprecated
    public UriTemplate(String template) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        Matcher matcher = VARIABLE_REGEX.matcher(template);
        int baseUriEndIndex = template.length();
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        while (matcher.find()) {
            String[] names;
            int start = matcher.start(0);
            TemplateVariable.VariableType type = TemplateVariable.VariableType.from(matcher.group(1));
            for (String name : names = matcher.group(2).split(",")) {
                TemplateVariable variable = name.endsWith(TemplateVariable.VariableType.COMPOSITE_PARAM.toString()) ? new TemplateVariable(name.substring(0, name.length() - 1), TemplateVariable.VariableType.COMPOSITE_PARAM) : new TemplateVariable(name, type);
                if (!variable.isRequired() && start < baseUriEndIndex) {
                    baseUriEndIndex = start;
                }
                variables.add(variable);
            }
        }
        this.variables = variables.isEmpty() ? TemplateVariables.NONE : new TemplateVariables(variables);
        this.baseUri = template.substring(0, baseUriEndIndex);
    }

    @Deprecated
    public UriTemplate(String baseUri, TemplateVariables variables) {
        Assert.hasText((String)baseUri, (String)"Base URI must not be null or empty!");
        Assert.notNull((Object)variables, (String)"Template variables must not be null!");
        this.baseUri = baseUri;
        this.variables = variables;
    }

    public static UriTemplate of(String template) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        return CACHE.computeIfAbsent(template, UriTemplate::new);
    }

    public static UriTemplate of(String template, TemplateVariables variables) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        return CACHE.computeIfAbsent(template, UriTemplate::new).with(variables);
    }

    public UriTemplate with(TemplateVariables variables) {
        Assert.notNull((Object)variables, (String)"TemplateVariables must not be null!");
        if (variables.equals(TemplateVariables.NONE)) {
            return this;
        }
        UriComponents components = UriComponentsBuilder.fromUriString((String)this.baseUri).build();
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>();
        for (TemplateVariable variable : variables) {
            boolean isRequestParam = variable.isRequestParameterVariable();
            boolean alreadyPresent = components.getQueryParams().containsKey((Object)variable.getName());
            if (isRequestParam && alreadyPresent || variable.isFragment() && StringUtils.hasText((String)components.getFragment())) continue;
            result.add(variable);
        }
        return new UriTemplate(this.baseUri, this.variables.concat(result));
    }

    public UriTemplate with(TemplateVariable variable) {
        Assert.notNull((Object)variable, (String)"Template variable must not be null!");
        return this.with(new TemplateVariables(variable));
    }

    public UriTemplate with(String variableName, TemplateVariable.VariableType type) {
        return this.with(new TemplateVariables(new TemplateVariable(variableName, type)));
    }

    public static boolean isTemplate(String candidate) {
        return StringUtils.hasText((String)candidate) ? VARIABLE_REGEX.matcher(candidate).find() : false;
    }

    public List<TemplateVariable> getVariables() {
        return this.variables.asList();
    }

    public List<String> getVariableNames() {
        return this.variables.asList().stream().map(TemplateVariable::getName).collect(Collectors.toList());
    }

    public URI expand(Object ... parameters) {
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        org.springframework.web.util.UriTemplate baseTemplate = new org.springframework.web.util.UriTemplate(this.baseUri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)baseTemplate.expand(parameters));
        Iterator<Object> iterator = Arrays.asList(parameters).iterator();
        for (TemplateVariable variable : this.getOptionalVariables()) {
            Object value = iterator.hasNext() ? iterator.next() : null;
            UriTemplate.appendToBuilder(builder, variable, value);
        }
        return builder.build().toUri();
    }

    public URI expand(Map<String, ?> parameters) {
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        org.springframework.web.util.UriTemplate baseTemplate = new org.springframework.web.util.UriTemplate(this.baseUri);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)baseTemplate.expand(parameters));
        for (TemplateVariable variable : this.getOptionalVariables()) {
            UriTemplate.appendToBuilder(builder, variable, parameters.get(variable.getName()));
        }
        return builder.build().toUri();
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        if (this.toString == null) {
            UriComponents components = UriComponentsBuilder.fromUriString((String)this.baseUri).build();
            boolean hasQueryParameters = !components.getQueryParams().isEmpty();
            this.toString = this.baseUri + this.getOptionalVariables().toString(hasQueryParameters);
        }
        return this.toString;
    }

    private TemplateVariables getOptionalVariables() {
        return this.variables.asList().stream().filter(variable -> !variable.isRequired()).collect(Collectors.collectingAndThen(Collectors.toList(), TemplateVariables::new));
    }

    private static void appendToBuilder(UriComponentsBuilder builder, TemplateVariable variable, @Nullable Object value) {
        if (value == null) {
            if (variable.isRequired()) {
                throw new IllegalArgumentException(String.format("Template variable %s is required but no value was given!", variable.getName()));
            }
            return;
        }
        switch (variable.getType()) {
            case COMPOSITE_PARAM: {
                UriTemplate.appendComposite(builder, variable.getName(), value);
                break;
            }
            case REQUEST_PARAM: 
            case REQUEST_PARAM_CONTINUED: {
                builder.queryParam(variable.getName(), new Object[]{value});
                break;
            }
            case PATH_VARIABLE: 
            case SEGMENT: {
                builder.pathSegment(new String[]{value.toString()});
                break;
            }
            case FRAGMENT: {
                builder.fragment(value.toString());
            }
        }
    }

    private static void appendComposite(UriComponentsBuilder builder, String name, Object value) {
        if (value instanceof Iterable) {
            ((Iterable)value).forEach(it -> builder.queryParam(name, new Object[]{it}));
        } else if (value instanceof Map) {
            ((Map)value).forEach((? super K key, ? super V value1) -> builder.queryParam(key.toString(), new Object[]{value1}));
        } else {
            builder.queryParam(name, new Object[]{value});
        }
    }
}

