/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.reactive.config.WebFluxConfigurer;

@Configuration
class WebFluxHateoasConfiguration {
    WebFluxHateoasConfiguration() {
    }

    @Bean
    WebFluxCodecs hypermediaConverters(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> mappingInformation) {
        return new WebFluxCodecs((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), mappingInformation);
    }

    @Bean
    HypermediaWebFluxConfigurer hypermediaWebFluxConfigurer(ObjectProvider<ObjectMapper> mapper, List<HypermediaMappingInformation> mappingInformation) {
        WebFluxCodecs codecs = new WebFluxCodecs((ObjectMapper)mapper.getIfAvailable(ObjectMapper::new), mappingInformation);
        return new HypermediaWebFluxConfigurer(codecs);
    }

    @Bean
    @Lazy
    ServerWebExchangeContextFilter serverWebExchangeContextFilter() {
        return new ServerWebExchangeContextFilter();
    }

    private static class WebFluxCodecs {
        private final List<Decoder<?>> decoders = new ArrayList();
        private final List<Encoder<?>> encoders = new ArrayList();

        private WebFluxCodecs(ObjectMapper mapper, List<HypermediaMappingInformation> mappingInformation) {
            for (HypermediaMappingInformation information : mappingInformation) {
                ObjectMapper objectMapper = information.configureObjectMapper(mapper.copy());
                List<MediaType> mediaTypes = information.getMediaTypes();
                this.decoders.add(WebFluxCodecs.getDecoder(objectMapper, mediaTypes));
                this.encoders.add(WebFluxCodecs.getEncoder(objectMapper, mediaTypes));
            }
        }

        public void registerCodecs(CodecConfigurer.CustomCodecs codecs) {
            this.decoders.forEach(arg_0 -> ((CodecConfigurer.CustomCodecs)codecs).decoder(arg_0));
            this.encoders.forEach(arg_0 -> ((CodecConfigurer.CustomCodecs)codecs).encoder(arg_0));
        }

        private static Decoder<?> getDecoder(ObjectMapper mapper, List<MediaType> mediaTypes) {
            return new Jackson2JsonDecoder(mapper, mediaTypes.toArray(new MimeType[0]));
        }

        private static Encoder<?> getEncoder(ObjectMapper mapper, List<MediaType> mediaTypes) {
            return new Jackson2JsonEncoder(mapper, mediaTypes.toArray(new MimeType[0]));
        }
    }

    static class HypermediaWebFluxConfigurer
    implements WebFluxConfigurer {
        private final WebFluxCodecs codecs;

        public void configureHttpMessageCodecs(ServerCodecConfigurer configurer) {
            this.codecs.registerCodecs(configurer.customCodecs());
        }

        @Generated
        public HypermediaWebFluxConfigurer(WebFluxCodecs codecs) {
            this.codecs = codecs;
        }
    }
}

