/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.AffordanceModel;

class TypeBasedPayloadMetadata
implements AffordanceModel.InputPayloadMetadata {
    private final ResolvableType type;
    private final SortedMap<String, AffordanceModel.PropertyMetadata> properties;

    TypeBasedPayloadMetadata(ResolvableType type, Stream<AffordanceModel.PropertyMetadata> properties) {
        this.type = type;
        this.properties = new TreeMap(properties.collect(Collectors.toMap(AffordanceModel.PropertyMetadata::getName, Function.identity())));
    }

    @Override
    public <T extends AffordanceModel.PropertyMetadataConfigured<T> & AffordanceModel.Named> T applyTo(T target) {
        AffordanceModel.PropertyMetadata metadata = (AffordanceModel.PropertyMetadata)this.properties.get(((AffordanceModel.Named)target).getName());
        return (T)(metadata == null ? target : (AffordanceModel.PropertyMetadataConfigured)target.apply(metadata));
    }

    @Override
    public <T extends AffordanceModel.Named> T customize(T target, Function<AffordanceModel.PropertyMetadata, T> customizer) {
        AffordanceModel.PropertyMetadata metadata = (AffordanceModel.PropertyMetadata)this.properties.get(target.getName());
        return (T)(metadata == null ? target : (AffordanceModel.Named)customizer.apply(metadata));
    }

    @Override
    public Stream<AffordanceModel.PropertyMetadata> stream() {
        return this.properties.values().stream();
    }

    @Override
    public List<String> getI18nCodes() {
        Class type = this.type.resolve(Object.class);
        return Arrays.asList(type.getName(), type.getSimpleName());
    }

    @Generated
    ResolvableType getType() {
        return this.type;
    }
}

