/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

public class UriTemplate
implements Iterable<TemplateVariable>,
Serializable {
    private static final Pattern VARIABLE_REGEX = Pattern.compile("\\{([\\?\\&#/\\.\\+\\;]?)([\\w(\\:\\d+)*%\\,*]+)\\}");
    private static final Pattern ELEMENT_REGEX = Pattern.compile("([\\w\\%]+)(\\:\\d+)?(\\*)?");
    private static final long serialVersionUID = -1007874653930162262L;
    private final TemplateVariables variables;
    private final ExpandGroups groups;
    private final String baseUri;
    private final String template;

    private UriTemplate(String template) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        int firstCurlyBraceIndex = template.indexOf(123);
        String baseUri = template = UriTemplate.prepareTemplate(template, firstCurlyBraceIndex);
        ArrayList<TemplateVariable> variables = new ArrayList<TemplateVariable>();
        ArrayList<ExpandGroup> expandGroups = new ArrayList<ExpandGroup>();
        if (firstCurlyBraceIndex != -1) {
            Matcher matcher = VARIABLE_REGEX.matcher(template);
            while (matcher.find()) {
                String typeFlag = matcher.group(1);
                String[] segments = matcher.group(2).split(",");
                TemplateVariable.VariableType type = TemplateVariable.VariableType.from(typeFlag);
                ArrayList<TemplateVariable> variableGroup = new ArrayList<TemplateVariable>();
                for (String segment : segments) {
                    Matcher inner = ELEMENT_REGEX.matcher(segment);
                    while (inner.find()) {
                        String name = inner.group(1);
                        String limit = inner.group(2);
                        String composite = inner.group(3);
                        TemplateVariable variable = new TemplateVariable(name, type);
                        variable = StringUtils.hasText((String)composite) ? variable.composite() : variable;
                        variable = StringUtils.hasText((String)limit) ? variable.limit(Integer.valueOf(limit.substring(1))) : variable;
                        variableGroup.add(variable);
                        variables.add(variable);
                    }
                }
                expandGroups.add(new ExpandGroup(variableGroup));
            }
        }
        this.variables = variables.isEmpty() ? TemplateVariables.NONE : new TemplateVariables(variables);
        this.groups = new ExpandGroups(expandGroups);
        this.baseUri = baseUri;
        this.template = template;
    }

    private UriTemplate(String baseUri, String template, TemplateVariables variables, ExpandGroups groups) {
        Assert.hasText((String)baseUri, (String)"Base URI must not be null or empty!");
        Assert.notNull((Object)variables, (String)"Template variables must not be null!");
        this.baseUri = baseUri;
        this.variables = variables;
        this.groups = groups;
        this.template = template;
    }

    public static UriTemplate of(String template) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        return new UriTemplate(template);
    }

    public static UriTemplate of(String template, TemplateVariables variables) {
        Assert.hasText((String)template, (String)"Template must not be null or empty!");
        return new UriTemplate(template).with(variables);
    }

    public UriTemplate with(TemplateVariables variables) {
        Assert.notNull((Object)variables, (String)"TemplateVariables must not be null!");
        if (variables.equals(TemplateVariables.NONE)) {
            return this;
        }
        UriComponents components = UriComponentsBuilder.fromUriString((String)this.baseUri).build();
        ArrayList<TemplateVariable> result = new ArrayList<TemplateVariable>();
        String newOriginal = this.template;
        ExpandGroups groups = this.groups;
        for (TemplateVariable variable : variables) {
            MultiValueMap parameters = components.getQueryParams();
            boolean isRequestParam = variable.isRequestParameterVariable();
            boolean alreadyPresent = parameters.containsKey((Object)variable.getName());
            if (isRequestParam && alreadyPresent || variable.isFragment() && StringUtils.hasText((String)components.getFragment())) continue;
            if (!parameters.isEmpty() && variable.getType().equals((Object)TemplateVariable.VariableType.REQUEST_PARAM)) {
                variable = variable.withType(TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
            }
            ExpandGroup existing = groups.findLastExpandGroupOfType(variable.getType());
            ExpandGroup group = new ExpandGroup(Collections.singletonList(variable));
            if (existing != null) {
                group = existing.merge(group);
                newOriginal = newOriginal.replace(existing.asString(), group.asString());
            } else {
                newOriginal = newOriginal.concat(group.asString());
            }
            groups = groups.addOrAugment(group);
            result.add(variable);
        }
        return new UriTemplate(this.baseUri, newOriginal, this.variables.concat(result), groups);
    }

    public UriTemplate with(TemplateVariable variable) {
        Assert.notNull((Object)variable, (String)"Template variable must not be null!");
        return this.with(new TemplateVariables(variable));
    }

    public UriTemplate with(String variableName, TemplateVariable.VariableType type) {
        return this.with(new TemplateVariables(new TemplateVariable(variableName, type)));
    }

    public static boolean isTemplate(String candidate) {
        return StringUtils.hasText((String)candidate) ? VARIABLE_REGEX.matcher(candidate).find() : false;
    }

    public List<TemplateVariable> getVariables() {
        return this.variables.asList();
    }

    public List<String> getVariableNames() {
        return this.variables.asList().stream().map(TemplateVariable::getName).collect(Collectors.toList());
    }

    public URI expand(Object ... parameters) {
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        Iterator<Object> iterator = Arrays.asList(parameters).iterator();
        HashMap foo = new HashMap();
        this.variables.stream().map(TemplateVariable::getName).forEach(it -> {
            Object value = iterator.hasNext() ? (Object)iterator.next() : null;
            foo.put(it, value);
        });
        return this.expand(foo);
    }

    public URI expand(Map<String, ?> parameters) {
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        if (TemplateVariables.NONE.equals(this.variables)) {
            return URI.create(this.baseUri);
        }
        String result = this.template;
        for (ExpandGroup group : this.groups.groupList) {
            result = result.replace(group.asString(), group.expand(parameters));
        }
        return URI.create(result);
    }

    @Override
    public Iterator<TemplateVariable> iterator() {
        return this.variables.iterator();
    }

    public String toString() {
        return this.template;
    }

    private static String prepareTemplate(String template, int index) {
        String decodedTemplate = UriUtils.decode((String)template, (Charset)StandardCharsets.UTF_8);
        if (decodedTemplate.length() != template.length()) {
            return template;
        }
        String head = index == -1 ? template : template.substring(0, index);
        String tail = index == -1 ? "" : template.substring(index);
        String encodedBase = head.endsWith("://") && tail.startsWith("{") ? head : UriComponentsBuilder.fromUriString((String)head).encode().build().toUriString();
        head = encodedBase.length() > head.length() ? encodedBase : head;
        return head + tail;
    }

    private static class ExpandGroup
    implements Expandable,
    Serializable {
        private static final long serialVersionUID = -6057608202572953271L;
        private final TemplateVariables variables;
        private final TemplateVariable.VariableType type;

        public ExpandGroup(List<TemplateVariable> variables) {
            this(new TemplateVariables(variables));
        }

        ExpandGroup(TemplateVariables variables) {
            this.variables = variables;
            this.type = variables.asList().get(0).getType();
        }

        ExpandGroup merge(ExpandGroup group) {
            Assert.isTrue((boolean)this.type.canBeCombinedWith(group.type), (String)"Incompatible expand groups!");
            return new ExpandGroup(this.variables.concat(group.variables));
        }

        @Override
        @Nullable
        public String expand(Map<String, ?> parameters) {
            return this.type.join(this.variables.stream().map(it -> it.expand(parameters)).filter(it -> it != null).collect(Collectors.toList()));
        }

        boolean canBeCombinedWith(TemplateVariable.VariableType type) {
            return this.type.canBeCombinedWith(type);
        }

        @Override
        public String asString() {
            return this.variables.stream().map(TemplateVariable::essence).collect(Collectors.joining(",", "{".concat(this.type.toString()), "}"));
        }

        public String toString() {
            return this.asString();
        }
    }

    private static class ExpandGroups
    implements Serializable {
        private static final long serialVersionUID = 6260926152179514011L;
        private final List<ExpandGroup> groupList;

        public ExpandGroups(List<ExpandGroup> groups) {
            this.groupList = groups;
        }

        public ExpandGroups addOrAugment(ExpandGroup group) {
            ExpandGroup existing = this.findLastExpandGroupOfType(group.type);
            ArrayList<ExpandGroup> foo = new ArrayList<ExpandGroup>(this.groupList);
            if (existing == null) {
                foo.add(group);
                return new ExpandGroups(foo);
            }
            ExpandGroup merged = existing.merge(group);
            foo.remove(existing);
            foo.add(merged);
            return new ExpandGroups(foo);
        }

        @Nullable
        ExpandGroup findLastExpandGroupOfType(TemplateVariable.VariableType type) {
            ExpandGroup result = null;
            for (ExpandGroup entry : this.groupList) {
                if (!entry.canBeCombinedWith(type)) continue;
                result = entry;
            }
            return result;
        }
    }

    static interface Expandable {
        @Nullable
        public String expand(Map<String, ?> var1);

        public String asString();
    }
}

