/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.config.HypermediaMappingInformationComparator;
import org.springframework.hateoas.config.MediaTypeConfigurationProvider;
import org.springframework.hateoas.config.WebTestHateoasConfiguration;
import org.springframework.http.MediaType;
import org.springframework.util.ClassUtils;

class HypermediaConfigurationImportSelector
implements ImportSelector,
ResourceLoaderAware,
BeanFactoryAware {
    public static final String SPRING_TEST = "org.springframework.test.web.reactive.server.WebTestClient";
    private @Nullable ResourceLoader resourceLoader;
    private @Nullable ConfigurableBeanFactory beanFactory;

    HypermediaConfigurationImportSelector() {
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        List<MediaType> types;
        if (this.beanFactory == null || this.resourceLoader == null) {
            return new String[0];
        }
        Map attributes = metadata.getAnnotationAttributes(EnableHypermediaSupport.class.getName());
        List<Object> list = types = attributes == null ? Collections.emptyList() : Arrays.stream((EnableHypermediaSupport.HypermediaType[])attributes.get("type")).flatMap(it -> it.getMediaTypes().stream()).collect(Collectors.toList());
        if (!this.beanFactory.containsBean("hateoasMediaTypeConfigurer")) {
            this.beanFactory.registerSingleton("hateoasMediaTypeConfigurer", (Object)new HypermediaMappingInformationComparator(types));
        }
        List configurationProviders = SpringFactoriesLoader.loadFactories(MediaTypeConfigurationProvider.class, (ClassLoader)HypermediaConfigurationImportSelector.class.getClassLoader());
        Stream<String> imports = configurationProviders.stream().filter(it -> it.supportsAny(types)).map(MediaTypeConfigurationProvider::getConfiguration).map(Class::getName);
        if (ClassUtils.isPresent((String)SPRING_TEST, (ClassLoader)this.resourceLoader.getClassLoader())) {
            imports = Stream.concat(imports, Stream.of(WebTestHateoasConfiguration.class.getName()));
        }
        return (String[])imports.toArray(String[]::new);
    }

    public String[] selectImports(List<MediaType> mediaType) {
        return new String[0];
    }
}

