/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.adapter.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemotingGatewayParser
extends AbstractSimpleBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)id)) {
            id = element.getAttribute("name");
        }
        if (!StringUtils.hasText((String)id)) {
            id = parserContext.getReaderContext().generateBeanName((BeanDefinition)definition);
        }
        return id;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !attributeName.equals("name") && !attributeName.equals("request-channel") && !attributeName.equals("reply-channel") && super.isEligibleAttribute(attributeName);
    }

    protected final void postProcess(BeanDefinitionBuilder builder, Element element) {
        String requestChannelRef = element.getAttribute("request-channel");
        Assert.hasText((String)requestChannelRef, (String)"a 'request-channel' reference is required");
        builder.addPropertyReference("requestChannel", requestChannelRef);
        String replyChannel = element.getAttribute("reply-channel");
        if (StringUtils.hasText((String)replyChannel)) {
            builder.addPropertyReference("replyChannel", replyChannel);
        }
        this.doPostProcess(builder, element);
    }

    protected void doPostProcess(BeanDefinitionBuilder builder, Element element) {
    }
}

