/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.debezium.dsl;

import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.JsonByteArray;
import io.debezium.engine.format.KeyValueHeaderChangeEventFormat;
import io.debezium.engine.format.SerializationFormat;
import java.util.Properties;
import org.springframework.integration.debezium.dsl.DebeziumMessageProducerSpec;
import org.springframework.util.Assert;

public final class Debezium {
    public static DebeziumMessageProducerSpec inboundChannelAdapter(Properties debeziumConfig) {
        return Debezium.inboundChannelAdapter(debeziumConfig, JsonByteArray.class, JsonByteArray.class);
    }

    public static DebeziumMessageProducerSpec inboundChannelAdapter(Properties debeziumConfig, Class<? extends SerializationFormat<byte[]>> messageFormat, Class<? extends SerializationFormat<byte[]>> headerFormat) {
        return Debezium.inboundChannelAdapter(Debezium.builder(debeziumConfig, messageFormat, headerFormat));
    }

    public static DebeziumMessageProducerSpec inboundChannelAdapter(DebeziumEngine.Builder<ChangeEvent<byte[], byte[]>> debeziumEngineBuilder) {
        return new DebeziumMessageProducerSpec(debeziumEngineBuilder);
    }

    private static DebeziumEngine.Builder<ChangeEvent<byte[], byte[]>> builder(Properties debeziumConfig, Class<? extends SerializationFormat<byte[]>> messageFormat, Class<? extends SerializationFormat<byte[]>> headerFormat) {
        Assert.notNull(messageFormat, (String)"'messageFormat' must not be null");
        Assert.notNull(headerFormat, (String)"'headerFormat' must not be null");
        Assert.notNull((Object)debeziumConfig, (String)"'debeziumConfig' must not be null");
        Assert.isTrue((boolean)debeziumConfig.containsKey("connector.class"), (String)"The 'connector.class' property must be set");
        return DebeziumEngine.create((KeyValueHeaderChangeEventFormat)KeyValueHeaderChangeEventFormat.of(messageFormat, messageFormat, headerFormat)).using(debeziumConfig);
    }

    private Debezium() {
    }
}

