/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.feed.inbound;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.integration.metadata.SimpleMetadataStore;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class FeedEntryMessageSource
extends AbstractMessageSource<SyndEntry> {
    private final URL feedUrl;
    private final Resource feedResource;
    private final String metadataKey;
    private final Queue<SyndEntry> entries = new ConcurrentLinkedQueue<SyndEntry>();
    private final Lock monitor = new ReentrantLock();
    private final Comparator<SyndEntry> syndEntryComparator = Comparator.comparing(FeedEntryMessageSource::getLastModifiedDate, Comparator.nullsFirst(Comparator.naturalOrder()));
    private final Lock feedMonitor = new ReentrantLock();
    private SyndFeedInput syndFeedInput = new SyndFeedInput();
    private boolean syndFeedInputSet;
    private MetadataStore metadataStore;
    private volatile long lastTime = -1L;
    private volatile boolean initialized;

    public FeedEntryMessageSource(URL feedUrl, String metadataKey) {
        Assert.notNull((Object)feedUrl, (String)"'feedUrl' must not be null");
        Assert.hasText((String)metadataKey, (String)"'metadataKey' must not be empty");
        this.feedUrl = feedUrl;
        this.metadataKey = metadataKey;
        this.feedResource = null;
    }

    public FeedEntryMessageSource(Resource feedResource, String metadataKey) {
        Assert.notNull((Object)feedResource, (String)"'feedResource' must not be null");
        Assert.hasText((String)metadataKey, (String)"'metadataKey' must not be empty");
        this.feedResource = feedResource;
        this.metadataKey = metadataKey;
        this.feedUrl = null;
    }

    public void setMetadataStore(MetadataStore metadataStore) {
        Assert.notNull((Object)metadataStore, (String)"'metadataStore' must not be null");
        this.metadataStore = metadataStore;
    }

    public void setSyndFeedInput(SyndFeedInput syndFeedInput) {
        Assert.notNull((Object)syndFeedInput, (String)"'syndFeedInput' must not be null");
        this.syndFeedInput = syndFeedInput;
        this.syndFeedInputSet = true;
    }

    public void setPreserveWireFeed(boolean preserveWireFeed) {
        Assert.isTrue((!this.syndFeedInputSet ? 1 : 0) != 0, () -> "'preserveWireFeed' must be configured on the provided [" + this.syndFeedInput + "]");
        this.syndFeedInput.setPreserveWireFeed(preserveWireFeed);
    }

    public String getComponentType() {
        return "feed:inbound-channel-adapter";
    }

    protected void onInit() {
        String lastTimeValue;
        if (this.metadataStore == null) {
            BeanFactory beanFactory = this.getBeanFactory();
            if (beanFactory != null) {
                this.metadataStore = IntegrationContextUtils.getMetadataStore((BeanFactory)beanFactory);
            }
            if (this.metadataStore == null) {
                this.metadataStore = new SimpleMetadataStore();
            }
        }
        if (StringUtils.hasText((String)(lastTimeValue = this.metadataStore.get(this.metadataKey)))) {
            this.lastTime = Long.parseLong(lastTimeValue);
        }
        this.initialized = true;
    }

    protected SyndEntry doReceive() {
        SyndEntry nextEntry;
        Assert.isTrue((boolean)this.initialized, (String)"'FeedEntryReaderMessageSource' must be initialized before it can produce Messages.");
        this.monitor.lock();
        try {
            nextEntry = this.getNextEntry();
            if (nextEntry == null) {
                this.populateEntryList();
                nextEntry = this.getNextEntry();
            }
        }
        finally {
            this.monitor.unlock();
        }
        return nextEntry;
    }

    private SyndEntry getNextEntry() {
        SyndEntry next = this.entries.poll();
        if (next == null) {
            return null;
        }
        Date lastModifiedDate = FeedEntryMessageSource.getLastModifiedDate(next);
        this.lastTime = lastModifiedDate != null ? lastModifiedDate.getTime() : ++this.lastTime;
        this.metadataStore.put(this.metadataKey, "" + this.lastTime);
        return next;
    }

    private void populateEntryList() {
        List retrievedEntries;
        SyndFeed syndFeed = this.getFeed();
        if (syndFeed != null && !CollectionUtils.isEmpty((Collection)(retrievedEntries = syndFeed.getEntries()))) {
            boolean withinNewEntries = false;
            retrievedEntries.sort(this.syndEntryComparator);
            for (SyndEntry entry : retrievedEntries) {
                Date entryDate = FeedEntryMessageSource.getLastModifiedDate(entry);
                if ((entryDate == null || entryDate.getTime() <= this.lastTime) && (entryDate != null || !withinNewEntries)) continue;
                this.entries.add(entry);
                withinNewEntries = true;
            }
        }
    }

    private SyndFeed getFeed() {
        this.feedMonitor.lock();
        try {
            SyndFeed feed = this.buildSyndFeed();
            this.logger.debug(() -> "Retrieved feed for [" + this + "]");
            if (feed == null) {
                this.logger.debug(() -> "No feeds updated for [" + this + "], returning null");
            }
            SyndFeed syndFeed = feed;
            this.feedMonitor.unlock();
            return syndFeed;
        }
        catch (Throwable throwable) {
            try {
                this.feedMonitor.unlock();
                throw throwable;
            }
            catch (Exception e) {
                throw new MessagingException("Failed to retrieve feed for '" + this + "'", (Throwable)e);
            }
        }
    }

    private SyndFeed buildSyndFeed() throws IOException, URISyntaxException, InterruptedException, FeedException {
        InputStream inputStream;
        if (this.feedResource != null) {
            inputStream = this.feedResource.getInputStream();
        } else {
            HttpRequest request = HttpRequest.newBuilder().GET().uri(this.feedUrl.toURI()).build();
            inputStream = HttpClient.newHttpClient().send(request, HttpResponse.BodyHandlers.ofInputStream()).body();
        }
        try (InputStream inputStream2 = inputStream;){
            SyndFeed syndFeed = this.syndFeedInput.build((Reader)new XmlReader(inputStream));
            return syndFeed;
        }
    }

    public String toString() {
        return "FeedEntryMessageSource{feedUrl=" + this.feedUrl + ", feedResource=" + this.feedResource + ", metadataKey='" + this.metadataKey + "', lastTime=" + this.lastTime + "}";
    }

    private static Date getLastModifiedDate(SyndEntry entry) {
        return entry.getUpdatedDate() != null ? entry.getUpdatedDate() : entry.getPublishedDate();
    }
}

