/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.MessagingException;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;
import org.springframework.integration.file.remote.synchronizer.InboundFileSynchronizer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInboundFileSynchronizer<F>
implements InboundFileSynchronizer,
InitializingBean {
    private String remoteFileSeparator = "/";
    static final String INCOMPLETE_EXTENSION = ".writing";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile String remoteDirectory;
    private final SessionFactory sessionFactory;
    private volatile FileListFilter<F> filter;
    private boolean deleteRemoteFiles;

    public AbstractInboundFileSynchronizer(SessionFactory sessionFactory) {
        Assert.notNull((Object)sessionFactory, (String)"sessionFactory must not be null");
        this.sessionFactory = sessionFactory;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.filter = filter;
    }

    public void setDeleteRemoteFiles(boolean deleteRemoteFiles) {
        this.deleteRemoteFiles = deleteRemoteFiles;
    }

    public final void afterPropertiesSet() {
        Assert.notNull((Object)this.remoteDirectory, (String)"remoteDirectory must not be null");
    }

    protected final List<F> filterFiles(F[] files) {
        return this.filter != null ? this.filter.filterFiles(files) : Arrays.asList(files);
    }

    @Override
    public void synchronizeToLocalDirectory(File localDirectory) {
        Session session = null;
        try {
            session = this.sessionFactory.getSession();
            Assert.state((session != null ? 1 : 0) != 0, (String)"failed to acquire a Session");
            Object[] files = session.list(this.remoteDirectory);
            if (!ObjectUtils.isEmpty((Object[])files)) {
                List<Object> filteredFiles = this.filterFiles(files);
                for (Object e : filteredFiles) {
                    if (e == null) continue;
                    this.copyFileToLocalDirectory(this.remoteDirectory, e, localDirectory, session);
                }
            }
        }
        catch (IOException e) {
            throw new MessagingException("Problem occurred while synchronizing remote to local directory", (Throwable)e);
        }
        finally {
            block13: {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception ignored) {
                        if (!this.logger.isDebugEnabled()) break block13;
                        this.logger.debug((Object)"failed to close Session", (Throwable)ignored);
                    }
                }
            }
        }
    }

    private void copyFileToLocalDirectory(String remoteDirectoryPath, F remoteFile, File localDirectory, Session session) throws IOException {
        String remoteFileName = this.getFilename(remoteFile);
        String remoteFilePath = remoteDirectoryPath + this.remoteFileSeparator + remoteFileName;
        if (!this.isFile(remoteFile)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("cannot copy, not a file: " + remoteFilePath));
            }
            return;
        }
        File localFile = new File(localDirectory, remoteFileName);
        if (!localFile.exists()) {
            String tempFileName = localFile.getAbsolutePath() + INCOMPLETE_EXTENSION;
            File tempFile = new File(tempFileName);
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = new FileOutputStream(tempFile);
            try {
                session.read(remoteFilePath, fileOutputStream);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new MessagingException("Failure occurred while copying from remote to local directory", (Throwable)e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception ignored1) {}
                try {
                    fileOutputStream.close();
                }
                catch (Exception ignored2) {}
            }
            if (tempFile.renameTo(localFile) && this.deleteRemoteFiles) {
                session.remove(remoteFilePath);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("deleted " + remoteFilePath));
                }
            }
        }
    }

    protected abstract boolean isFile(F var1);

    protected abstract String getFilename(F var1);
}

