/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractOutboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class RemoteFileOutboundChannelAdapterParser
extends AbstractOutboundChannelAdapterParser {
    protected AbstractBeanDefinition parseConsumer(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder sessionFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.remote.session.CachingSessionFactory");
        sessionFactoryBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        BeanDefinitionBuilder handlerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.remote.handler.FileTransferringMessageHandler");
        handlerBuilder.addConstructorArgValue((Object)sessionFactoryBuilder.getBeanDefinition());
        String remoteDirectory = element.getAttribute("remote-directory");
        String remoteDirectoryExpression = element.getAttribute("remote-directory-expression");
        boolean hasRemoteDirectory = StringUtils.hasText((String)remoteDirectory);
        boolean hasRemoteDirectoryExpression = StringUtils.hasText((String)remoteDirectoryExpression);
        if (!(hasRemoteDirectory ^ hasRemoteDirectoryExpression)) {
            throw new BeanDefinitionStoreException("exactly one of 'remote-directory' or 'remote-directory-expression' is required on a remote file outbound adapter");
        }
        RootBeanDefinition remoteDirectoryExpressionDefinition = null;
        if (hasRemoteDirectory) {
            remoteDirectoryExpressionDefinition = new RootBeanDefinition("org.springframework.expression.common.LiteralExpression");
            remoteDirectoryExpressionDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)remoteDirectory);
        } else if (hasRemoteDirectoryExpression) {
            remoteDirectoryExpressionDefinition = new RootBeanDefinition("org.springframework.integration.config.ExpressionFactoryBean");
            remoteDirectoryExpressionDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)remoteDirectoryExpression);
        }
        handlerBuilder.addPropertyValue("remoteDirectoryExpression", (Object)remoteDirectoryExpressionDefinition);
        String remoteFileNameGenerator = element.getAttribute("remote-filename-generator");
        String remoteFileNameGeneratorExpression = element.getAttribute("remote-filename-generator-expression");
        boolean hasRemoteFileNameGenerator = StringUtils.hasText((String)remoteFileNameGenerator);
        boolean hasRemoteFileNameGeneratorExpression = StringUtils.hasText((String)remoteFileNameGeneratorExpression);
        if (hasRemoteFileNameGenerator || hasRemoteFileNameGeneratorExpression) {
            if (hasRemoteFileNameGenerator && hasRemoteFileNameGeneratorExpression) {
                throw new BeanDefinitionStoreException("at most one of 'remote-filename-generator-expression' or 'remote-filename-generator' is allowed on a remote file outbound adapter");
            }
            if (hasRemoteFileNameGenerator) {
                handlerBuilder.addPropertyReference("fileNameGenerator", remoteFileNameGenerator);
            } else {
                BeanDefinitionBuilder fileNameGeneratorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.file.DefaultFileNameGenerator");
                fileNameGeneratorBuilder.addPropertyValue("expression", (Object)remoteFileNameGeneratorExpression);
                handlerBuilder.addPropertyValue("fileNameGenerator", (Object)fileNameGeneratorBuilder.getBeanDefinition());
            }
        }
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"charset");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)handlerBuilder, (Element)element, (String)"remote-file-separator");
        return handlerBuilder.getBeanDefinition();
    }
}

