/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.session;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.remote.session.SessionFactory;

public class CachingSessionFactory
implements SessionFactory,
DisposableBean {
    private static final Log logger = LogFactory.getLog(CachingSessionFactory.class);
    public static final int DEFAULT_POOL_SIZE = 10;
    private final Queue<Session> queue;
    private final SessionFactory sessionFactory;
    private final int maxPoolSize;

    public CachingSessionFactory(SessionFactory sessionFactory) {
        this(sessionFactory, 10);
    }

    public CachingSessionFactory(SessionFactory sessionFactory, int maxPoolSize) {
        this.sessionFactory = sessionFactory;
        this.maxPoolSize = maxPoolSize;
        this.queue = new ArrayBlockingQueue<Session>(this.maxPoolSize, true);
    }

    public Session getSession() {
        Session session = this.queue.poll();
        if (session == null || !session.isOpen()) {
            if (session != null && logger.isTraceEnabled()) {
                logger.trace((Object)"Located session in the pool but it is stale, will create new one.");
            }
            session = this.sessionFactory.getSession();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Created new session");
            }
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Using session from the pool");
        }
        return new CachedSession(session);
    }

    public void destroy() {
        if (this.queue != null) {
            for (Session session : this.queue) {
                this.closeSession(session);
            }
        }
    }

    private void closeSession(Session session) {
        block3: {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Throwable e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn((Object)"Exception was thrown while destroying Session. ", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CachedSession
    implements Session {
        private final Session targetSession;

        private CachedSession(Session targetSession) {
            this.targetSession = targetSession;
        }

        @Override
        public void close() {
            if (CachingSessionFactory.this.queue.size() < CachingSessionFactory.this.maxPoolSize) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Releasing target session back to the pool");
                }
                CachingSessionFactory.this.queue.add(this.targetSession);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Disconnecting target session");
                }
                this.targetSession.close();
            }
        }

        @Override
        public boolean remove(String path) throws IOException {
            return this.targetSession.remove(path);
        }

        @Override
        public <F> F[] list(String path) throws IOException {
            return this.targetSession.list(path);
        }

        @Override
        public void read(String source, OutputStream os) throws IOException {
            this.targetSession.read(source, os);
        }

        @Override
        public void write(InputStream inputStream, String destination) throws IOException {
            this.targetSession.write(inputStream, destination);
        }

        @Override
        public boolean isOpen() {
            return this.targetSession.isOpen();
        }

        @Override
        public void rename(String pathFrom, String pathTo) throws IOException {
            this.targetSession.rename(pathFrom, pathTo);
        }

        @Override
        public void mkdir(String directory) throws IOException {
            this.targetSession.mkdir(directory);
        }
    }
}

