/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import java.io.File;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.file.FileNameGenerator;
import org.springframework.integration.file.FileWritingMessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileWritingMessageHandlerFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<FileWritingMessageHandler> {
    private volatile File directory;
    private volatile String charset;
    private volatile FileNameGenerator fileNameGenerator;
    private volatile Boolean deleteSourceFiles;
    private volatile Boolean autoCreateDirectory;
    private volatile Boolean requiresReply;
    private volatile Long sendTimeout;
    private volatile String temporaryFileSuffix;

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setFileNameGenerator(FileNameGenerator fileNameGenerator) {
        this.fileNameGenerator = fileNameGenerator;
    }

    public void setDeleteSourceFiles(Boolean deleteSourceFiles) {
        this.deleteSourceFiles = deleteSourceFiles;
    }

    public void setAutoCreateDirectory(Boolean autoCreateDirectory) {
        this.autoCreateDirectory = autoCreateDirectory;
    }

    public void setRequiresReply(Boolean requiresReply) {
        this.requiresReply = requiresReply;
    }

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setTemporaryFileSuffix(String temporaryFileSuffix) {
        this.temporaryFileSuffix = temporaryFileSuffix;
    }

    protected FileWritingMessageHandler createHandler() {
        FileWritingMessageHandler handler = new FileWritingMessageHandler(this.directory);
        if (this.charset != null) {
            handler.setCharset(this.charset);
        }
        if (this.fileNameGenerator != null) {
            handler.setFileNameGenerator(this.fileNameGenerator);
        }
        if (this.deleteSourceFiles != null) {
            handler.setDeleteSourceFiles(this.deleteSourceFiles);
        }
        if (this.autoCreateDirectory != null) {
            handler.setAutoCreateDirectory(this.autoCreateDirectory);
        }
        if (this.requiresReply != null) {
            handler.setRequiresReply(this.requiresReply);
        }
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout);
        }
        if (this.temporaryFileSuffix != null) {
            handler.setTemporaryFileSuffix(this.temporaryFileSuffix);
        }
        return handler;
    }
}

