/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.filters;

import org.springframework.integration.file.filters.AbstractFileListFilter;
import org.springframework.integration.metadata.MetadataStore;
import org.springframework.util.Assert;

public abstract class AbstractPersistentAcceptOnceFileListFilter<F>
extends AbstractFileListFilter<F> {
    protected final MetadataStore store;
    protected final String prefix;
    private final Object monitor = new Object();

    public AbstractPersistentAcceptOnceFileListFilter(MetadataStore store, String prefix) {
        Assert.notNull((Object)store, (String)"'store' cannot be null");
        Assert.notNull((Object)prefix, (String)"'prefix' cannot be null");
        this.store = store;
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean accept(F file) {
        String key = this.buildKey(file);
        Object object = this.monitor;
        synchronized (object) {
            String value = this.store.get(key);
            if (value != null && this.isEqual(file, value)) {
                return false;
            }
            this.store.put(key, this.value(file));
        }
        return true;
    }

    private String value(F file) {
        return Long.toString(this.modified(file));
    }

    protected boolean isEqual(F file, String value) {
        return Long.valueOf(value).longValue() == this.modified(file);
    }

    protected String buildKey(F file) {
        return this.prefix + this.fileName(file);
    }

    protected abstract long modified(F var1);

    protected abstract String fileName(F var1);
}

