/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.splitter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.integration.splitter.AbstractMessageSplitter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public class FileSplitter
extends AbstractMessageSplitter {
    private final boolean iterator;
    private Charset charset;

    public FileSplitter() {
        this(true);
    }

    public FileSplitter(boolean iterator) {
        this.iterator = iterator;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected Object splitMessage(final Message<?> message) {
        Object payload = message.getPayload();
        Reader reader = null;
        if (payload instanceof String) {
            try {
                reader = new FileReader((String)payload);
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof File) {
            try {
                if (this.charset == null) {
                    reader = new FileReader((File)payload);
                }
                reader = new InputStreamReader((InputStream)new FileInputStream((File)payload), this.charset);
            }
            catch (FileNotFoundException e) {
                throw new MessageHandlingException(message, "failed to read file [" + payload + "]", (Throwable)e);
            }
        } else if (payload instanceof InputStream) {
            reader = this.charset == null ? new InputStreamReader((InputStream)payload) : new InputStreamReader((InputStream)payload, this.charset);
        } else if (payload instanceof Reader) {
            reader = (Reader)payload;
        } else {
            return message;
        }
        final BufferedReader bufferedReader = new BufferedReader(reader);
        Iterator<String> iterator = new Iterator<String>(){

            @Override
            public boolean hasNext() {
                try {
                    boolean ready = bufferedReader.ready();
                    if (!ready) {
                        bufferedReader.close();
                    }
                    return ready;
                }
                catch (IOException e) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new MessageHandlingException(message, "IOException while iterating", (Throwable)e);
                }
            }

            @Override
            public String next() {
                try {
                    return bufferedReader.readLine();
                }
                catch (IOException e) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new MessageHandlingException(message, "IOException while iterating", (Throwable)e);
                }
            }
        };
        if (this.iterator) {
            return iterator;
        }
        ArrayList lines = new ArrayList();
        while (iterator.hasNext()) {
            lines.add(iterator.next());
        }
        return lines;
    }
}

