/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.xml.AbstractPollingInboundChannelAdapterParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractRemoteFileInboundChannelAdapterParser
extends AbstractPollingInboundChannelAdapterParser {
    protected final BeanMetadataElement parseSource(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder synchronizerBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getInboundFileSynchronizerClassname());
        synchronizerBuilder.addConstructorArgReference(element.getAttribute("session-factory"));
        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression((String)"remote-directory", (String)"remote-directory-expression", (ParserContext)parserContext, (Element)element, (boolean)true);
        synchronizerBuilder.addPropertyValue("remoteDirectoryExpression", (Object)expressionDef);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"delete-remote-files");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"preserve-timestamp");
        String remoteFileSeparator = element.getAttribute("remote-file-separator");
        synchronizerBuilder.addPropertyValue("remoteFileSeparator", (Object)remoteFileSeparator);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)synchronizerBuilder, (Element)element, (String)"temporary-file-suffix");
        this.configureFilter(synchronizerBuilder, element, parserContext);
        BeanDefinitionBuilder messageSourceBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getMessageSourceClassname());
        messageSourceBuilder.addConstructorArgValue((Object)synchronizerBuilder.getBeanDefinition());
        String comparator = element.getAttribute("comparator");
        if (StringUtils.hasText((String)comparator)) {
            messageSourceBuilder.addConstructorArgReference(comparator);
        }
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"local-filter");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"local-directory");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)messageSourceBuilder, (Element)element, (String)"auto-create-local-directory");
        String localFileGeneratorExpression = element.getAttribute("local-filename-generator-expression");
        if (StringUtils.hasText((String)localFileGeneratorExpression)) {
            BeanDefinitionBuilder localFileGeneratorExpressionBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class);
            localFileGeneratorExpressionBuilder.addConstructorArgValue((Object)localFileGeneratorExpression);
            synchronizerBuilder.addPropertyValue("localFilenameGeneratorExpression", (Object)localFileGeneratorExpressionBuilder.getBeanDefinition());
        }
        return messageSourceBuilder.getBeanDefinition();
    }

    private void configureFilter(BeanDefinitionBuilder synchronizerBuilder, Element element, ParserContext parserContext) {
        String filter = element.getAttribute("filter");
        String fileNamePattern = element.getAttribute("filename-pattern");
        String fileNameRegex = element.getAttribute("filename-regex");
        boolean hasFilter = StringUtils.hasText((String)filter);
        boolean hasFileNamePattern = StringUtils.hasText((String)fileNamePattern);
        boolean hasFileNameRegex = StringUtils.hasText((String)fileNameRegex);
        if (hasFilter || hasFileNamePattern || hasFileNameRegex) {
            int count = 0;
            if (hasFilter) {
                ++count;
            }
            if (hasFileNamePattern) {
                ++count;
            }
            if (hasFileNameRegex) {
                ++count;
            }
            if (count != 1) {
                parserContext.getReaderContext().error("at most one of 'filename-pattern', 'filename-regex', or 'filter' is allowed on remote file inbound adapter", (Object)element);
            }
            if (hasFilter) {
                synchronizerBuilder.addPropertyReference("filter", filter);
            } else if (hasFileNamePattern) {
                BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getSimplePatternFileListFilterClassname());
                filterBuilder.addConstructorArgValue((Object)fileNamePattern);
                synchronizerBuilder.addPropertyValue("filter", (Object)filterBuilder.getBeanDefinition());
            } else if (hasFileNameRegex) {
                BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)this.getRegexPatternFileListFilterClassname());
                filterBuilder.addConstructorArgValue((Object)fileNameRegex);
                synchronizerBuilder.addPropertyValue("filter", (Object)filterBuilder.getBeanDefinition());
            }
        }
    }

    protected abstract String getMessageSourceClassname();

    protected abstract String getInboundFileSynchronizerClassname();

    protected abstract String getSimplePatternFileListFilterClassname();

    protected abstract String getRegexPatternFileListFilterClassname();
}

