/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.file.DefaultDirectoryScanner;
import org.springframework.lang.UsesJava7;
import org.springframework.util.Assert;

@Deprecated
@UsesJava7
public class WatchServiceDirectoryScanner
extends DefaultDirectoryScanner
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(WatchServiceDirectoryScanner.class);
    private final Path directory;
    private volatile WatchService watcher;
    private volatile int phase;
    private volatile boolean running;
    private volatile boolean autoStartup;
    private volatile Collection<File> initialFiles;

    public WatchServiceDirectoryScanner(String directory) {
        this.directory = Paths.get(directory, new String[0]);
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                this.watcher = FileSystems.getDefault().newWatchService();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to create watcher for " + this.directory.toString()), (Throwable)e);
            }
            Set<File> initialFiles = this.walkDirectory(this.directory);
            initialFiles.addAll(this.filesFromEvents());
            this.initialFiles = initialFiles;
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                logger.error((Object)("Failed to close watcher for " + this.directory.toString()), (Throwable)e);
            }
            this.running = false;
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    @Override
    protected File[] listEligibleFiles(File directory) {
        Assert.state((this.watcher != null ? 1 : 0) != 0, (String)"Scanner needs to be started");
        if (this.initialFiles != null) {
            File[] initial = this.initialFiles.toArray(new File[this.initialFiles.size()]);
            this.initialFiles = null;
            return initial;
        }
        Set<File> files = this.filesFromEvents();
        return files.toArray(new File[files.size()]);
    }

    private Set<File> filesFromEvents() {
        WatchKey key = this.watcher.poll();
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        while (key != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    Path item = (Path)event.context();
                    File file = new File(((Path)key.watchable()).toAbsolutePath() + File.separator + item.getFileName());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Watch Event: " + event.kind() + ": " + file));
                    }
                    if (file.isDirectory()) {
                        files.addAll(this.walkDirectory(file.toPath()));
                        continue;
                    }
                    files.add(file);
                    continue;
                }
                if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Watch Event: " + event.kind() + ": context: " + event.context()));
                    }
                    if (event.context() != null && event.context() instanceof Path) {
                        files.addAll(this.walkDirectory((Path)event.context()));
                        continue;
                    }
                    files.addAll(this.walkDirectory(this.directory));
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Watch Event: " + event.kind() + ": context: " + event.context()));
            }
            key.reset();
            key = this.watcher.poll();
        }
        return files;
    }

    private Set<File> walkDirectory(Path directory) {
        final LinkedHashSet<File> walkedFiles = new LinkedHashSet<File>();
        try {
            this.registerWatch(directory);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult fileVisitResult = super.preVisitDirectory(dir, attrs);
                    WatchServiceDirectoryScanner.this.registerWatch(dir);
                    return fileVisitResult;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                    walkedFiles.add(file.toFile());
                    return fileVisitResult;
                }
            });
        }
        catch (IOException e) {
            logger.error((Object)("Failed to walk directory: " + directory.toString()), (Throwable)e);
        }
        return walkedFiles;
    }

    private void registerWatch(Path dir) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registering: " + dir + " for file creation events"));
        }
        dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
    }
}

