/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.log.LogMessage;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.endpoint.AbstractFetchLimitingMessageSource;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.ResettableFileListFilter;
import org.springframework.integration.file.filters.ReversibleFileListFilter;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.integration.file.remote.RemoteFileTemplate;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.integration.file.support.FileUtils;
import org.springframework.integration.support.management.ManageableLifecycle;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractRemoteFileStreamingMessageSource<F>
extends AbstractFetchLimitingMessageSource<InputStream>
implements ManageableLifecycle {
    private final RemoteFileTemplate<? extends F> remoteFileTemplate;
    private final BlockingQueue<AbstractFileInfo<F>> toBeReceived = new LinkedBlockingQueue<AbstractFileInfo<F>>();
    private final Comparator<? extends F> comparator;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicInteger fetched = new AtomicInteger();
    private boolean fileInfoJson = true;
    private Expression remoteDirectoryExpression;
    private String remoteFileSeparator = "/";
    private FileListFilter<F> filter;
    private boolean strictOrder;

    protected AbstractRemoteFileStreamingMessageSource(RemoteFileTemplate<? extends F> template, @Nullable Comparator<? extends F> comparator) {
        Assert.notNull(template, (String)"'template' must not be null");
        this.remoteFileTemplate = template;
        this.comparator = comparator;
    }

    public void setRemoteDirectory(String remoteDirectory) {
        this.remoteDirectoryExpression = new LiteralExpression(remoteDirectory);
    }

    public void setRemoteDirectoryExpression(Expression remoteDirectoryExpression) {
        Assert.notNull((Object)remoteDirectoryExpression, (String)"'remoteDirectoryExpression' must not be null");
        this.remoteDirectoryExpression = remoteDirectoryExpression;
    }

    public void setRemoteFileSeparator(String remoteFileSeparator) {
        Assert.notNull((Object)remoteFileSeparator, (String)"'remoteFileSeparator' must not be null");
        this.remoteFileSeparator = remoteFileSeparator;
    }

    public void setFilter(FileListFilter<F> filter) {
        this.doSetFilter(filter);
    }

    protected final void doSetFilter(FileListFilter<F> filterToSet) {
        this.filter = filterToSet;
    }

    public void setFileInfoJson(boolean fileInfoJson) {
        this.fileInfoJson = fileInfoJson;
    }

    public void setStrictOrder(boolean strictOrder) {
        this.strictOrder = strictOrder;
    }

    protected RemoteFileTemplate<? extends F> getRemoteFileTemplate() {
        return this.remoteFileTemplate;
    }

    public final void onInit() {
        Assert.state((this.remoteDirectoryExpression != null ? 1 : 0) != 0, (String)"'remoteDirectoryExpression' must not be null");
        this.doInit();
    }

    protected void doInit() {
    }

    public void start() {
        this.running.set(true);
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            if (this.filter == null || this.filter.supportsSingleFileFiltering()) {
                this.toBeReceived.clear();
            } else {
                AbstractFileInfo file = (AbstractFileInfo)this.toBeReceived.poll();
                while (file != null) {
                    this.resetFilterIfNecessary(file);
                    file = (AbstractFileInfo)this.toBeReceived.poll();
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    protected Object doReceive(int maxFetchSize) {
        Assert.state((boolean)this.running.get(), () -> this.getComponentName() + " is not running");
        if (maxFetchSize > 0 && this.fetched.get() >= maxFetchSize) {
            this.toBeReceived.clear();
            this.fetched.set(0);
        }
        AbstractFileInfo<F> file = this.poll();
        while (file != null) {
            if (this.filter != null && this.filter.supportsSingleFileFiltering() && !this.filter.accept(file.getFileInfo())) {
                if (this.toBeReceived.isEmpty()) break;
                file = this.poll();
                continue;
            }
            if (maxFetchSize > 0) {
                this.fetched.incrementAndGet();
            }
            return this.remoteFileToMessage(file);
        }
        return null;
    }

    private Object remoteFileToMessage(AbstractFileInfo<F> file) {
        try {
            String remotePath = this.remotePath(file);
            Session<F> session = this.remoteFileTemplate.getSession();
            try {
                return this.getMessageBuilderFactory().withPayload((Object)session.readRaw(remotePath)).setHeader("closeableResource", session).setHeader("file_remoteDirectory", (Object)file.getRemoteDirectory()).setHeader("file_remoteFile", (Object)file.getFilename()).setHeader("file_remoteHostPort", (Object)session.getHostPort()).setHeader("file_remoteFileInfo", this.fileInfoJson ? file.toJson() : file);
            }
            catch (IOException e) {
                session.close();
                throw new UncheckedIOException("IOException when retrieving " + remotePath, e);
            }
        }
        catch (RuntimeException ex) {
            if (this.strictOrder) {
                ArrayList<AbstractFileInfo<F>> filesToReset = new ArrayList<AbstractFileInfo<F>>();
                filesToReset.add(file);
                this.toBeReceived.drainTo(filesToReset);
                filesToReset.forEach(this::resetFilterIfNecessary);
            } else {
                this.resetFilterIfNecessary(file);
            }
            throw ex;
        }
    }

    protected AbstractFileInfo<F> poll() {
        if (this.toBeReceived.isEmpty()) {
            this.listFiles();
        }
        return (AbstractFileInfo)this.toBeReceived.poll();
    }

    private void resetFilterIfNecessary(AbstractFileInfo<F> file) {
        if (this.filter instanceof ResettableFileListFilter) {
            this.logger.info((CharSequence)LogMessage.format((String)"Removing the remote file '%s' from the filter for a subsequent transfer attempt", (Object)file.getFilename()));
            ((ResettableFileListFilter)this.filter).remove(file.getFileInfo());
        }
    }

    protected String remotePath(AbstractFileInfo<F> file) {
        return file.getRemoteDirectory().endsWith(this.remoteFileSeparator) ? file.getRemoteDirectory() + file.getFilename() : file.getRemoteDirectory() + this.remoteFileSeparator + file.getFilename();
    }

    private void listFiles() {
        String remoteDirectory = (String)this.remoteDirectoryExpression.getValue((EvaluationContext)this.getEvaluationContext(), String.class);
        Object[] files = this.remoteFileTemplate.list(remoteDirectory);
        if (!ObjectUtils.isEmpty((Object[])files)) {
            files = FileUtils.purgeUnwantedElements(files, f -> f == null || this.isDirectory(f), this.comparator);
        }
        if (!ObjectUtils.isEmpty((Object[])files)) {
            List<AbstractFileInfo<Object>> fileInfoList;
            if (this.filter != null && !this.filter.supportsSingleFileFiltering()) {
                int maxFetchSize = this.getMaxFetchSize() - this.fetched.get();
                List<Object> filteredFiles = this.filter.filterFiles(files);
                if (maxFetchSize > 0 && filteredFiles.size() > maxFetchSize) {
                    this.rollbackFromFileToListEnd(filteredFiles, filteredFiles.get(maxFetchSize));
                    ArrayList<Object> newList = new ArrayList<Object>(maxFetchSize);
                    for (int i = 0; i < maxFetchSize; ++i) {
                        newList.add(filteredFiles.get(i));
                    }
                    filteredFiles = newList;
                }
                fileInfoList = this.asFileInfoList(filteredFiles);
            } else {
                fileInfoList = this.asFileInfoList(Arrays.asList(files));
            }
            fileInfoList.forEach(fi -> fi.setRemoteDirectory(remoteDirectory));
            this.toBeReceived.addAll(fileInfoList);
        }
    }

    protected void rollbackFromFileToListEnd(List<F> filteredFiles, F file) {
        if (this.filter instanceof ReversibleFileListFilter) {
            ((ReversibleFileListFilter)this.filter).rollback(file, filteredFiles);
        }
    }

    protected abstract List<AbstractFileInfo<F>> asFileInfoList(Collection<F> var1);

    protected abstract boolean isDirectory(F var1);
}

