/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.http.MultipartFileReader;
import org.springframework.integration.http.UploadedMultipartFile;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCopyingMultipartFileReader
implements MultipartFileReader<MultipartFile> {
    private static final Log logger = LogFactory.getLog(FileCopyingMultipartFileReader.class);
    private final File directory;
    private volatile String prefix = "si_";
    private volatile String suffix = ".tmp";

    public FileCopyingMultipartFileReader() {
        this(null);
    }

    public FileCopyingMultipartFileReader(File directory) {
        this.directory = directory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public MultipartFile readMultipartFile(MultipartFile multipartFile) throws IOException {
        File upload = File.createTempFile(this.prefix, this.suffix, this.directory);
        multipartFile.transferTo(upload);
        UploadedMultipartFile uploadedMultipartFile = new UploadedMultipartFile(upload, multipartFile.getSize(), multipartFile.getContentType(), multipartFile.getName(), multipartFile.getOriginalFilename());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copied uploaded file [" + multipartFile.getOriginalFilename() + "] to [" + upload.getAbsolutePath() + "]"));
        }
        return uploadedMultipartFile;
    }
}

