/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.Message;
import org.springframework.integration.MessagingException;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.integration.http.converter.SerializingHttpMessageConverter;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class HttpRequestHandlingEndpointSupport
extends MessagingGatewaySupport {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private volatile List<HttpMethod> supportedMethods = Arrays.asList(HttpMethod.GET, HttpMethod.POST);
    private volatile Class<?> requestPayloadType = null;
    private volatile List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private volatile HeaderMapper<HttpHeaders> headerMapper = new DefaultHttpHeaderMapper();
    private final boolean expectReply;
    private volatile boolean extractReplyPayload = true;
    private volatile MultipartResolver multipartResolver;

    public HttpRequestHandlingEndpointSupport() {
        this(true);
    }

    public HttpRequestHandlingEndpointSupport(boolean expectReply) {
        this.expectReply = expectReply;
        this.messageConverters.add(new MultipartAwareFormHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new SerializingHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        if (jaxb2Present) {
            this.messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (jacksonPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
        }
        if (romePresent) {
            // empty if block
        }
    }

    protected boolean isExpectReply() {
        return this.expectReply;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setSupportedMethodNames(String ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        HttpMethod[] methodArray = new HttpMethod[supportedMethods.length];
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray[i] = HttpMethod.valueOf((String)supportedMethods[i].toUpperCase());
        }
        this.supportedMethods = Arrays.asList(methodArray);
    }

    public void setSupportedMethods(HttpMethod ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        this.supportedMethods = Arrays.asList(supportedMethods);
    }

    public void setRequestPayloadType(Class<?> requestPayloadType) {
        this.requestPayloadType = requestPayloadType;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    public String getComponentType() {
        return this.expectReply ? "http:inbound-gateway" : "http:inbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        block4: {
            super.onInit();
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.multipartResolver == null && beanFactory != null) {
                try {
                    MultipartResolver multipartResolver = (MultipartResolver)this.getBeanFactory().getBean("multipartResolver", MultipartResolver.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
                    }
                    this.multipartResolver = multipartResolver;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object doHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            ServletServerHttpRequest request = this.prepareRequest(servletRequest);
            if (!this.supportedMethods.contains(request.getMethod())) {
                servletResponse.setStatus(405);
                Object var4_4 = null;
                return var4_4;
            }
            LinkedMultiValueMap<String, String> payload = null;
            payload = this.isReadable(request) ? this.generatePayloadFromRequestBody(request) : this.convertParameterMap(servletRequest.getParameterMap());
            Map headers = this.headerMapper.toHeaders((Object)request.getHeaders());
            Message message = MessageBuilder.withPayload(payload).copyHeaders(headers).setHeader("http_requestUrl", (Object)request.getURI().toString()).setHeader("http_requestMethod", (Object)request.getMethod().toString()).setHeader("http_userPrincipal", (Object)servletRequest.getUserPrincipal()).build();
            Object reply = null;
            if (this.expectReply) {
                reply = this.sendAndReceiveMessage(message);
                if (reply != null) {
                    ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
                    this.headerMapper.fromHeaders(reply.getHeaders(), (Object)response.getHeaders());
                    if (this.extractReplyPayload) {
                        reply = reply.getPayload();
                    }
                }
            } else {
                this.send(message);
            }
            Message message2 = reply;
            return message2;
        }
        finally {
            this.postProcessRequest(servletRequest);
        }
    }

    private ServletServerHttpRequest prepareRequest(HttpServletRequest servletRequest) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            return new MultipartHttpInputMessage((MultipartHttpServletRequest)servletRequest);
        }
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(servletRequest)) {
            return new MultipartHttpInputMessage(this.multipartResolver.resolveMultipart(servletRequest));
        }
        return new ServletServerHttpRequest(servletRequest);
    }

    private boolean isReadable(ServletServerHttpRequest request) {
        HttpMethod method = request.getMethod();
        if (HttpMethod.GET.equals((Object)method) || HttpMethod.HEAD.equals((Object)method) || HttpMethod.OPTIONS.equals((Object)method)) {
            return false;
        }
        return request.getHeaders().getContentType() != null;
    }

    private void postProcessRequest(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private LinkedMultiValueMap<String, String> convertParameterMap(Map parameterMap) {
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap();
        for (Object key : parameterMap.keySet()) {
            String[] values;
            for (String value : values = (String[])parameterMap.get(key)) {
                convertedMap.add((Object)((String)key), (Object)value);
            }
        }
        return convertedMap;
    }

    private Object generatePayloadFromRequestBody(ServletServerHttpRequest request) throws IOException {
        MediaType contentType = request.getHeaders().getContentType();
        Class<Object> expectedType = this.requestPayloadType;
        if (expectedType == null) {
            expectedType = "text".equals(contentType.getType()) ? String.class : byte[].class;
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canRead(expectedType, contentType)) continue;
            return converter.read(expectedType, (HttpInputMessage)request);
        }
        throw new MessagingException("Could not convert request: no suitable HttpMessageConverter found for expected type [" + expectedType.getName() + "] and content type [" + contentType + "]");
    }
}

