/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.integration.http.inbound.HttpRequestHandlingEndpointSupport;
import org.springframework.validation.MapBindingResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

public class HttpRequestHandlingController
extends HttpRequestHandlingEndpointSupport
implements Controller {
    private static final String DEFAULT_ERROR_CODE = "spring.integration.http.handler.error";
    private static final String DEFAULT_REPLY_KEY = "reply";
    private static final String DEFAULT_ERRORS_KEY = "errors";
    private volatile String viewName;
    private volatile String replyKey = "reply";
    private volatile String errorsKey = "errors";
    private volatile String errorCode = "spring.integration.http.handler.error";

    public HttpRequestHandlingController() {
        this(true);
    }

    public HttpRequestHandlingController(boolean expectReply) {
        super(expectReply);
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public void setReplyKey(String replyKey) {
        this.replyKey = replyKey != null ? replyKey : DEFAULT_REPLY_KEY;
    }

    public void setErrorsKey(String errorsKey) {
        this.errorsKey = errorsKey;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public final ModelAndView handleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        ModelAndView modelAndView = new ModelAndView();
        if (this.viewName != null) {
            modelAndView.setViewName(this.viewName);
        }
        try {
            Object reply = super.doHandleRequest(servletRequest, servletResponse);
            if (reply != null) {
                modelAndView.addObject(this.replyKey, reply);
            }
        }
        catch (Exception e) {
            MapBindingResult errors = new MapBindingResult(new HashMap(), "dummy");
            PrintWriter stackTrace = new PrintWriter(new StringWriter());
            e.printStackTrace(stackTrace);
            errors.reject(this.errorCode, new Object[]{e, e.getMessage(), stackTrace.toString()}, "A Spring Integration handler raised an exception while handling an HTTP request.  The exception is of type " + e.getClass() + " and it has a message: (" + e.getMessage() + ")");
            modelAndView.addObject(this.errorsKey, (Object)errors);
        }
        return modelAndView;
    }
}

