/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.inbound;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.MessagingException;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.integration.http.multipart.MultipartHttpInputMessage;
import org.springframework.integration.http.support.DefaultHttpHeaderMapper;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpRequestHandlingEndpointSupport
extends MessagingGatewaySupport
implements OrderlyShutdownCapable {
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static final boolean jacksonPresent = ClassUtils.isPresent((String)"org.codehaus.jackson.map.ObjectMapper", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader()) && ClassUtils.isPresent((String)"org.codehaus.jackson.JsonGenerator", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private static boolean romePresent = ClassUtils.isPresent((String)"com.sun.syndication.feed.WireFeed", (ClassLoader)HttpRequestHandlingEndpointSupport.class.getClassLoader());
    private volatile List<HttpMethod> supportedMethods = Arrays.asList(HttpMethod.GET, HttpMethod.POST);
    private volatile Class<?> requestPayloadType = null;
    private volatile List<HttpMessageConverter<?>> messageConverters = new ArrayList();
    private volatile HeaderMapper<HttpHeaders> headerMapper = DefaultHttpHeaderMapper.inboundMapper();
    private final boolean expectReply;
    private volatile String path;
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private final PathMatcher pathMatcher = new AntPathMatcher();
    private volatile boolean extractReplyPayload = true;
    private volatile MultipartResolver multipartResolver;
    private volatile Expression payloadExpression;
    private volatile Map<String, Expression> headerExpressions;
    private volatile boolean shuttingDown;
    private final AtomicInteger activeCount = new AtomicInteger();

    public HttpRequestHandlingEndpointSupport() {
        this(true);
    }

    public HttpRequestHandlingEndpointSupport(boolean expectReply) {
        this.expectReply = expectReply;
        this.messageConverters.add(new MultipartAwareFormHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        this.messageConverters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        if (jaxb2Present) {
            this.messageConverters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        }
        if (jacksonPresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new MappingJacksonHttpMessageConverter());
        }
        if (romePresent) {
            this.messageConverters.add((HttpMessageConverter<?>)new AtomFeedHttpMessageConverter());
            this.messageConverters.add((HttpMessageConverter<?>)new RssChannelHttpMessageConverter());
        }
    }

    protected boolean isExpectReply() {
        return this.expectReply;
    }

    public void setPath(String path) {
        this.path = path;
    }

    String getPath() {
        return this.path;
    }

    public void setPayloadExpression(Expression payloadExpression) {
        this.payloadExpression = payloadExpression;
    }

    public void setHeaderExpressions(Map<String, Expression> headerExpressions) {
        this.headerExpressions = headerExpressions;
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, (String)"'messageConverters' must not be empty");
        this.messageConverters = messageConverters;
    }

    protected List<HttpMessageConverter<?>> getMessageConverters() {
        return this.messageConverters;
    }

    public void setHeaderMapper(HeaderMapper<HttpHeaders> headerMapper) {
        Assert.notNull(headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setSupportedMethodNames(String ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        HttpMethod[] methodArray = new HttpMethod[supportedMethods.length];
        for (int i = 0; i < methodArray.length; ++i) {
            methodArray[i] = HttpMethod.valueOf((String)supportedMethods[i].toUpperCase());
        }
        this.supportedMethods = Arrays.asList(methodArray);
    }

    public void setSupportedMethods(HttpMethod ... supportedMethods) {
        Assert.notEmpty((Object[])supportedMethods, (String)"at least one supported method is required");
        this.supportedMethods = Arrays.asList(supportedMethods);
    }

    public void setRequestPayloadType(Class<?> requestPayloadType) {
        this.requestPayloadType = requestPayloadType;
    }

    public void setExtractReplyPayload(boolean extractReplyPayload) {
        this.extractReplyPayload = extractReplyPayload;
    }

    public void setMultipartResolver(MultipartResolver multipartResolver) {
        this.multipartResolver = multipartResolver;
    }

    protected boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public String getComponentType() {
        return this.expectReply ? "http:inbound-gateway" : "http:inbound-channel-adapter";
    }

    protected void onInit() throws Exception {
        block4: {
            super.onInit();
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.multipartResolver == null && beanFactory != null) {
                try {
                    MultipartResolver multipartResolver = (MultipartResolver)this.getBeanFactory().getBean("multipartResolver", MultipartResolver.class);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
                    }
                    this.multipartResolver = multipartResolver;
                }
                catch (NoSuchBeanDefinitionException e) {
                    if (!this.logger.isDebugEnabled()) break block4;
                    this.logger.debug((Object)"Unable to locate MultipartResolver with name 'multipartResolver': no multipart request handling will be supported.");
                }
            }
        }
        this.validateSupportedMethods();
    }

    protected void doStart() {
        this.shuttingDown = false;
        super.doStart();
    }

    protected final Message<?> doHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        if (this.isShuttingDown()) {
            return this.createServiceUnavailableResponse();
        }
        return this.actualDoHandleRequest(servletRequest, servletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message<?> actualDoHandleRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        this.activeCount.incrementAndGet();
        try {
            String lookupPath;
            Map pathVariables;
            ServletServerHttpRequest request = this.prepareRequest(servletRequest);
            if (!this.supportedMethods.contains(request.getMethod())) {
                servletResponse.setStatus(405);
                Message<?> message = null;
                return message;
            }
            Object requestBody = null;
            if (this.isReadable(request)) {
                requestBody = this.extractRequestBody(request);
            }
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)request.getHeaders());
            StandardEvaluationContext evaluationContext = this.createEvaluationContext();
            evaluationContext.setRootObject((Object)httpEntity);
            LinkedMultiValueMap<String, String> requestParams = this.convertParameterMap(servletRequest.getParameterMap());
            evaluationContext.setVariable("requestParams", requestParams);
            if (StringUtils.hasText((String)this.path) && !(pathVariables = this.pathMatcher.extractUriTemplateVariables(this.path, lookupPath = this.urlPathHelper.getLookupPathForRequest(servletRequest))).isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Mapped path variables: " + pathVariables));
                }
                evaluationContext.setVariable("pathVariables", (Object)pathVariables);
            }
            Map headers = this.headerMapper.toHeaders((Object)request.getHeaders());
            Object payload = null;
            if (this.payloadExpression != null) {
                payload = this.payloadExpression.getValue((EvaluationContext)evaluationContext);
            }
            if (!CollectionUtils.isEmpty(this.headerExpressions)) {
                for (String headerName : this.headerExpressions.keySet()) {
                    Expression headerExpression = this.headerExpressions.get(headerName);
                    Object headerValue = headerExpression.getValue((EvaluationContext)evaluationContext);
                    if (headerValue == null) continue;
                    headers.put(headerName, headerValue);
                }
            }
            if (payload == null) {
                payload = requestBody != null ? requestBody : requestParams;
            }
            MessageBuilder messageBuilder = null;
            messageBuilder = payload instanceof Message ? MessageBuilder.fromMessage((Message)((Message)payload)).copyHeadersIfAbsent(headers) : MessageBuilder.withPayload(payload).copyHeaders(headers);
            Message message = messageBuilder.setHeader("http_requestUrl", (Object)request.getURI().toString()).setHeader("http_requestMethod", (Object)request.getMethod().toString()).setHeader("http_userPrincipal", (Object)servletRequest.getUserPrincipal()).build();
            Message reply = null;
            if (this.expectReply) {
                reply = this.sendAndReceiveMessage(message);
            } else {
                this.send(message);
            }
            Message message2 = reply;
            return message2;
        }
        finally {
            this.postProcessRequest(servletRequest);
            this.activeCount.decrementAndGet();
        }
    }

    private Message<?> createServiceUnavailableResponse() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Endpoint is shutting down; returning status " + HttpStatus.SERVICE_UNAVAILABLE));
        }
        return MessageBuilder.withPayload((Object)"Endpoint is shutting down").setHeader("http_statusCode", (Object)HttpStatus.SERVICE_UNAVAILABLE).build();
    }

    protected final Object setupResponseAndConvertReply(ServletServerHttpResponse response, Message<?> replyMessage) {
        this.headerMapper.fromHeaders(replyMessage.getHeaders(), (Object)response.getHeaders());
        HttpStatus httpStatus = this.resolveHttpStatusFromHeaders(replyMessage.getHeaders());
        if (httpStatus != null) {
            response.setStatusCode(httpStatus);
        }
        Object reply = replyMessage;
        if (this.extractReplyPayload) {
            reply = replyMessage.getPayload();
        }
        return reply;
    }

    @Deprecated
    protected final Object setupResponseAndConvertReply(HttpServletResponse servletResponse, Message<?> replyMessage) {
        ServletServerHttpResponse response = new ServletServerHttpResponse(servletResponse);
        Object reply = this.setupResponseAndConvertReply(response, replyMessage);
        response.close();
        return reply;
    }

    private ServletServerHttpRequest prepareRequest(HttpServletRequest servletRequest) {
        if (servletRequest instanceof MultipartHttpServletRequest) {
            return new MultipartHttpInputMessage((MultipartHttpServletRequest)servletRequest);
        }
        if (this.multipartResolver != null && this.multipartResolver.isMultipart(servletRequest)) {
            return new MultipartHttpInputMessage(this.multipartResolver.resolveMultipart(servletRequest));
        }
        return new ServletServerHttpRequest(servletRequest);
    }

    private boolean isReadable(ServletServerHttpRequest request) {
        HttpMethod method = request.getMethod();
        if (HttpMethod.GET.equals((Object)method) || HttpMethod.HEAD.equals((Object)method) || HttpMethod.OPTIONS.equals((Object)method)) {
            return false;
        }
        return request.getHeaders().getContentType() != null;
    }

    private void postProcessRequest(HttpServletRequest request) {
        if (this.multipartResolver != null && request instanceof MultipartHttpServletRequest) {
            this.multipartResolver.cleanupMultipart((MultipartHttpServletRequest)request);
        }
    }

    private LinkedMultiValueMap<String, String> convertParameterMap(Map parameterMap) {
        LinkedMultiValueMap convertedMap = new LinkedMultiValueMap();
        for (Object key : parameterMap.keySet()) {
            String[] values;
            for (String value : values = (String[])parameterMap.get(key)) {
                convertedMap.add((Object)((String)key), (Object)value);
            }
        }
        return convertedMap;
    }

    private Object extractRequestBody(ServletServerHttpRequest request) throws IOException {
        MediaType contentType = request.getHeaders().getContentType();
        Class<Object> expectedType = this.requestPayloadType;
        if (expectedType == null) {
            expectedType = "text".equals(contentType.getType()) ? String.class : byte[].class;
        }
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (!converter.canRead(expectedType, contentType)) continue;
            return converter.read(expectedType, (HttpInputMessage)request);
        }
        throw new MessagingException("Could not convert request: no suitable HttpMessageConverter found for expected type [" + expectedType.getName() + "] and content type [" + contentType + "]");
    }

    private HttpStatus resolveHttpStatusFromHeaders(MessageHeaders headers) {
        Object httpStatusFromHeader = headers.get((Object)"http_statusCode");
        HttpStatus httpStatus = null;
        if (httpStatusFromHeader instanceof HttpStatus) {
            httpStatus = (HttpStatus)httpStatusFromHeader;
        } else if (httpStatusFromHeader instanceof Integer) {
            httpStatus = HttpStatus.valueOf((int)((Integer)httpStatusFromHeader));
        } else if (httpStatusFromHeader instanceof String) {
            httpStatus = HttpStatus.valueOf((int)Integer.parseInt((String)httpStatusFromHeader));
        }
        return httpStatus;
    }

    protected StandardEvaluationContext createEvaluationContext() {
        if (this.getBeanFactory() != null) {
            return ExpressionUtils.createStandardEvaluationContext((BeanResolver)new BeanFactoryResolver(this.getBeanFactory()), (ConversionService)this.getConversionService());
        }
        return ExpressionUtils.createStandardEvaluationContext((ConversionService)this.getConversionService());
    }

    private void validateSupportedMethods() {
        if (this.requestPayloadType != null) {
            for (HttpMethod httpMethod : this.supportedMethods) {
                if (!HttpMethod.GET.equals((Object)httpMethod) && !HttpMethod.HEAD.equals((Object)httpMethod) && !HttpMethod.OPTIONS.equals((Object)httpMethod) || !this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)("The 'requestPayloadType' attribute will have no relevance for one of the specified HTTP methods '" + httpMethod + "'"));
            }
        }
    }

    public int beforeShutdown() {
        this.shuttingDown = true;
        return this.activeCount.get();
    }

    public int afterShutdown() {
        return this.activeCount.get();
    }
}

