/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.http.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.graph.IntegrationGraphServer;
import org.springframework.integration.http.config.EnableIntegrationGraphController;
import org.springframework.integration.http.management.IntegrationGraphController;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

class IntegrationGraphControllerRegistrar
implements ImportBeanDefinitionRegistrar {
    IntegrationGraphControllerRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        String[] allowedOrigins;
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnableIntegrationGraphController.class.getName());
        if (!registry.containsBeanDefinition("integrationGraphServer")) {
            registry.registerBeanDefinition("integrationGraphServer", (BeanDefinition)new RootBeanDefinition(IntegrationGraphServer.class));
        }
        if ((allowedOrigins = (String[])annotationAttributes.get("allowedOrigins")) != null && allowedOrigins.length > 0) {
            AbstractBeanDefinition controllerCorsConfigurer = BeanDefinitionBuilder.genericBeanDefinition(IntegrationGraphCorsConfigurer.class).addConstructorArgValue(annotationAttributes.get("value")).addConstructorArgValue((Object)allowedOrigins).getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)controllerCorsConfigurer, (BeanDefinitionRegistry)registry);
        }
        if (!registry.containsBeanDefinition("integrationGraphController")) {
            AbstractBeanDefinition controllerPropertiesPopulator = BeanDefinitionBuilder.genericBeanDefinition(GraphControllerPropertiesPopulator.class).addConstructorArgValue((Object)annotationAttributes).setRole(2).getBeanDefinition();
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)controllerPropertiesPopulator, (BeanDefinitionRegistry)registry);
            AbstractBeanDefinition graphController = BeanDefinitionBuilder.genericBeanDefinition(IntegrationGraphController.class).addConstructorArgReference("integrationGraphServer").getBeanDefinition();
            registry.registerBeanDefinition("integrationGraphController", (BeanDefinition)graphController);
        }
    }

    private static final class IntegrationGraphCorsConfigurer
    implements WebMvcConfigurer {
        private final String path;
        private final String[] allowedOrigins;

        private IntegrationGraphCorsConfigurer(String path, String[] allowedOrigins) {
            this.path = path;
            this.allowedOrigins = allowedOrigins;
        }

        public void addCorsMappings(CorsRegistry registry) {
            registry.addMapping(this.path).allowedOrigins(this.allowedOrigins).allowedMethods(new String[]{"GET"});
        }
    }

    private static final class GraphControllerPropertiesPopulator
    implements BeanFactoryPostProcessor,
    EnvironmentAware {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        private GraphControllerPropertiesPopulator(Map<String, Object> annotationAttributes) {
            Object graphControllerPath = annotationAttributes.get("value");
            this.properties.put("spring.integration.graph.controller.request.mapping.path", graphControllerPath);
        }

        public void setEnvironment(Environment environment) {
            ((ConfigurableEnvironment)environment).getPropertySources().addLast((PropertySource)new MapPropertySource("integrationGraphController_properties", this.properties));
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

