/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.ip.tcp;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.integration.Message;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.ip.tcp.connection.AbstractServerConnectionFactory;
import org.springframework.integration.ip.tcp.connection.TcpConnection;
import org.springframework.integration.ip.tcp.connection.TcpListener;
import org.springframework.integration.ip.tcp.connection.TcpSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpInboundGateway
extends MessagingGatewaySupport
implements TcpListener,
TcpSender {
    protected AbstractServerConnectionFactory connectionFactory;
    private Map<String, TcpConnection> connections = new ConcurrentHashMap<String, TcpConnection>();

    @Override
    public boolean onMessage(Message<?> message) {
        Message reply = this.sendAndReceiveMessage(message);
        if (reply == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("null reply received for " + message + " nothing to send"));
            }
            return false;
        }
        String connectionId = (String)message.getHeaders().get((Object)"ip_connection_id");
        TcpConnection connection = this.connections.get(connectionId);
        if (connection == null) {
            this.logger.error((Object)("Connection " + connectionId + " not found when processing reply for " + message));
            return false;
        }
        try {
            connection.send(reply);
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to send reply", (Throwable)e);
        }
        return false;
    }

    public boolean isListening() {
        return this.connectionFactory.isListening();
    }

    public void setConnectionFactory(AbstractServerConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        connectionFactory.registerListener(this);
        connectionFactory.registerSender(this);
    }

    @Override
    public void addNewConnection(TcpConnection connection) {
        this.connections.put(connection.getConnectionId(), connection);
    }

    @Override
    public void removeDeadConnection(TcpConnection connection) {
        this.connections.remove(connection.getConnectionId());
    }

    public String getComponentType() {
        return "ip:tcp-inbound-gateway";
    }
}

